/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.GraphScorer;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.FgesRunner;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScoredGraphsWrapper
implements SessionModel,
GraphSource,
Unmarshallable,
DoNotAddOldModel {
    static final long serialVersionUID = 23L;
    private String name;
    private Graph selectedGraph;
    private final Map<Graph, Double> graphsToScores;
    private final transient GraphScorer graphScorer;

    private ScoredGraphsWrapper() {
        this.graphsToScores = null;
        this.graphScorer = null;
    }

    public ScoredGraphsWrapper(Graph graph, GraphScorer scorer) {
        List<Graph> dags = SearchGraphUtils.generateCpdagDags(graph, true);
        this.graphsToScores = new HashMap<Graph, Double>();
        this.graphScorer = scorer;
        for (Graph _graph : dags) {
            double score = Double.NaN;
            if (scorer != null) {
                score = scorer.scoreDag(_graph);
            }
            this.graphsToScores.put(_graph, score);
        }
        if (!this.graphsToScores.keySet().isEmpty()) {
            boolean index = false;
            this.selectedGraph = this.graphsToScores.keySet().iterator().next();
        }
        this.log();
    }

    public ScoredGraphsWrapper(FgesRunner runner, Parameters parameters) {
        this(runner.getTopGraphs().get(runner.getIndex()).getGraph(), runner.getGraphScorer());
    }

    public ScoredGraphsWrapper(DagWrapper wrapper, Parameters parameters) {
        this(wrapper.getGraph(), null);
    }

    public ScoredGraphsWrapper(GraphWrapper wrapper, Parameters parameters) {
        this(wrapper.getGraph(), null);
    }

    public ScoredGraphsWrapper(SemGraphWrapper wrapper, Parameters parameters) {
        this(wrapper.getGraph(), null);
    }

    public ScoredGraphsWrapper(PcRunner wrapper, Parameters parameters) {
        this(wrapper.getGraph(), null);
    }

    public static ScoredGraphsWrapper serializableInstance() {
        return new ScoredGraphsWrapper(PcRunner.serializableInstance(), new Parameters());
    }

    public Map<Graph, Double> getGraphsToScores() {
        LinkedHashMap<Graph, Double> _graphsToScores = new LinkedHashMap<Graph, Double>();
        for (Graph graph : this.graphsToScores.keySet()) {
            _graphsToScores.put(new EdgeListGraph(graph), this.graphsToScores.get(graph));
        }
        return _graphsToScores;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log() {
        TetradLogger.getInstance().log("info", "DAGs in forbid_latent_common_causes");
        TetradLogger.getInstance().log("selected_graph", "\nSelected Graph\n");
        TetradLogger.getInstance().log("selected_graph", this.getGraph() + "");
        TetradLogger.getInstance().log("all_graphs", "\nAll Graphs:\n");
        int index = 0;
        for (Graph graph : this.graphsToScores.keySet()) {
            TetradLogger.getInstance().log("all_graphs", "\nGraph #" + ++index);
            TetradLogger.getInstance().log("all_graphs", graph + "");
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public Graph getGraph() {
        return this.selectedGraph;
    }

    public Graph getSelectedGraph() {
        return this.selectedGraph;
    }

    public void setSelectedGraph(Graph graph) {
        if (!this.graphsToScores.containsKey(graph)) {
            throw new IllegalArgumentException("Not a graph in this set.");
        }
        this.selectedGraph = graph;
    }

    public GraphScorer getGraphScorer() {
        return this.graphScorer;
    }
}

