/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.ScoreType;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerEm;
import edu.cmu.tetrad.sem.SemOptimizerPowell;
import edu.cmu.tetrad.sem.SemOptimizerRegression;
import edu.cmu.tetrad.sem.SemOptimizerRicf;
import edu.cmu.tetrad.sem.SemOptimizerScattershot;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class SemEstimatorWrapper
implements SessionModel,
Unmarshallable {
    static final long serialVersionUID = 23L;
    private final Parameters params;
    private String name;
    private SemEstimator semEstimator;
    private final SemPm semPm;

    public SemEstimatorWrapper(DataModel dataModel, SemPm semPm, Parameters params) {
        this.params = params;
        this.semPm = semPm;
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            SemEstimator estimator = new SemEstimator(dataSet, semPm, this.getOptimizer());
            estimator.setNumRestarts(this.getParams().getInt("numRestarts", 1));
            estimator.setScoreType((ScoreType)((Object)this.getParams().get("scoreType", (Object)ScoreType.Fgls)));
            estimator.estimate();
            if (!this.degreesOfFreedomCheck(semPm)) {
                throw new IllegalArgumentException("Cannot proceed.");
            }
            this.semEstimator = estimator;
        } else if (dataModel instanceof ICovarianceMatrix) {
            CovarianceMatrix covMatrix = new CovarianceMatrix((ICovarianceMatrix)dataModel);
            SemEstimator estimator = new SemEstimator(covMatrix, semPm, this.getOptimizer());
            estimator.setNumRestarts(this.getParams().getInt("numRestarts", 1));
            estimator.setScoreType((ScoreType)((Object)this.getParams().get("scoreType", (Object)ScoreType.Fml)));
            estimator.estimate();
            if (!this.degreesOfFreedomCheck(semPm)) {
                throw new IllegalArgumentException("Cannot proceed.");
            }
            this.semEstimator = estimator;
        } else {
            throw new IllegalArgumentException("Data must consist of continuous data sets or covariance matrices.");
        }
    }

    public SemEstimatorWrapper(DataWrapper dataWrapper, SemPmWrapper semPmWrapper, Parameters params) {
        this(dataWrapper.getSelectedDataModel(), semPmWrapper.getSemPm(), params);
        this.log();
    }

    public static SemEstimatorWrapper serializableInstance() {
        LinkedList<Node> variables = new LinkedList<Node>();
        ContinuousVariable x = new ContinuousVariable("X");
        variables.add(x);
        BoxDataSet dataSet = new BoxDataSet(new VerticalDoubleDataBox(10, variables.size()), variables);
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                dataSet.setDouble(i, j, RandomUtil.getInstance().nextDouble());
            }
        }
        Dag dag = new Dag();
        dag.addNode(x);
        SemPm pm = new SemPm(dag);
        Parameters params1 = new Parameters();
        return new SemEstimatorWrapper(dataSet, pm, params1);
    }

    private static boolean containsCovarParam(SemPm semPm) {
        boolean containsCovarParam = false;
        List<Parameter> params = semPm.getParameters();
        for (Parameter param : params) {
            if (param.getType() != ParamType.COVAR) continue;
            containsCovarParam = true;
            break;
        }
        return containsCovarParam;
    }

    private boolean degreesOfFreedomCheck(SemPm semPm) {
        if (semPm.getDof() < 1) {
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "This model has nonpositive degrees of freedom (DOF = " + semPm.getDof() + "). \nEstimation will be uninformative. Are you sure you want to proceed?", "Please confirm", 0, 2);
            return ret == 0;
        }
        return true;
    }

    public SemEstimator getSemEstimator() {
        return this.semEstimator;
    }

    public void setSemEstimator(SemEstimator semEstimator) {
        this.semEstimator = semEstimator;
    }

    public SemIm getEstimatedSemIm() {
        return this.semEstimator.getEstimatedSem();
    }

    public String getSemOptimizerType() {
        return this.getParams().getString("semOptimizerType", "Regression");
    }

    public void setSemOptimizerType(String type) {
        this.getParams().set("semOptimizerType", type);
    }

    public Graph getGraph() {
        return this.semEstimator.getEstimatedSem().getSemPm().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log() {
        TetradLogger.getInstance().log("info", "SEM Estimator:");
        TetradLogger.getInstance().log("im", "" + this.getEstimatedSemIm());
        TetradLogger.getInstance().log("details", "ChiSq = " + this.getEstimatedSemIm().getChiSquare());
        TetradLogger.getInstance().log("details", "DOF = " + this.getEstimatedSemIm().getSemPm().getDof());
        TetradLogger.getInstance().log("details", "P = " + this.getEstimatedSemIm().getPValue());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public Parameters getParams() {
        return this.params;
    }

    private SemOptimizer getOptimizer() {
        SemOptimizer optimizer;
        String type = this.getParams().getString("semOptimizerType", "Regression");
        if ("Regression".equals(type)) {
            SemOptimizer defaultOptimization = this.getDefaultOptimization();
            if (!(defaultOptimization instanceof SemOptimizerRegression)) {
                optimizer = defaultOptimization;
                type = this.getType(defaultOptimization);
                this.getParams().set("semOptimizerType", type);
            } else {
                optimizer = new SemOptimizerRegression();
            }
        } else if ("EM".equals(type)) {
            optimizer = new SemOptimizerEm();
        } else if ("Powell".equals(type)) {
            optimizer = new SemOptimizerPowell();
        } else if ("Random Search".equals(type)) {
            optimizer = new SemOptimizerScattershot();
        } else if ("RICF".equals(type)) {
            optimizer = new SemOptimizerRicf();
        } else if (this.semPm != null) {
            optimizer = this.getDefaultOptimization();
            String _type = this.getType(optimizer);
            if (_type != null) {
                this.getParams().set("semOptimizerType", _type);
            }
        } else {
            optimizer = null;
        }
        return optimizer;
    }

    private String getType(SemOptimizer optimizer) {
        String _type = null;
        if (optimizer instanceof SemOptimizerRegression) {
            _type = "Regression";
        } else if (optimizer instanceof SemOptimizerEm) {
            _type = "EM";
        } else if (optimizer instanceof SemOptimizerPowell) {
            _type = "Powell";
        } else if (optimizer instanceof SemOptimizerScattershot) {
            _type = "Random Search";
        } else if (optimizer instanceof SemOptimizerRicf) {
            _type = "RICF";
        }
        return _type;
    }

    private boolean containsFixedParam(SemPm semPm) {
        return new SemIm(semPm).getNumFixedParams() > 0;
    }

    public ScoreType getScoreType() {
        return (ScoreType)((Object)this.params.get("scoreType", (Object)ScoreType.SemBic));
    }

    public void setScoreType(ScoreType scoreType) {
        this.params.set("scoreType", (Object)scoreType);
    }

    public int getNumRestarts() {
        return this.getParams().getInt("numRestarts", 1);
    }

    public void setNumRestarts(int numRestarts) {
        this.getParams().set("numRestarts", (Object)numRestarts);
    }

    private SemOptimizer getDefaultOptimization() {
        if (this.semPm == null) {
            throw new NullPointerException("Sorry, I didn't see a SEM PM as parent to the estimator; perhaps the parents are wrong.");
        }
        boolean containsLatent = false;
        for (Node node : this.semPm.getGraph().getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            containsLatent = true;
            break;
        }
        SemOptimizer optimizer = this.containsFixedParam(this.semPm) || this.semPm.getGraph().paths().existsDirectedCycle() || SemEstimatorWrapper.containsCovarParam(this.semPm) ? new SemOptimizerPowell() : (containsLatent ? new SemOptimizerEm() : new SemOptimizerRegression());
        optimizer.setNumRestarts(this.getParams().getInt("numRestarts", 1));
        return optimizer;
    }
}

