/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.session.SimulationParamsSource;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.MultipleGraphSource;
import edu.cmu.tetradapp.model.RegressionRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.Simulation;
import edu.cmu.tetradapp.util.GraphUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemGraphWrapper
implements GraphSource,
KnowledgeBoxInput,
SimulationParamsSource,
DoNotAddOldModel,
MultipleGraphSource {
    static final long serialVersionUID = 23L;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;
    private String name;
    private List<Graph> graphs;
    private Map<String, String> allParamSettings;
    private Parameters parameters = new Parameters();

    public SemGraphWrapper(GraphSource graphSource, Parameters parameters) {
        if (graphSource instanceof Simulation) {
            Simulation simulation = (Simulation)graphSource;
            List<Graph> graphs = simulation.getGraphs();
            this.graphs = new ArrayList<Graph>();
            for (Graph graph : graphs) {
                this.graphs.add(new SemGraph(graph));
            }
            this.numModels = this.graphs.size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        } else {
            this.setGraph(new SemGraph(graphSource.getGraph()));
        }
        this.log();
    }

    public SemGraphWrapper(SemGraph graph) {
        if (graph == null) {
            throw new NullPointerException("MAG must not be null.");
        }
        this.setSemGraph(graph);
        this.getSemGraph().setShowErrorTerms(false);
        this.parameters = new Parameters();
        this.log();
    }

    public SemGraphWrapper(Parameters params) {
        if (params.getString("newGraphInitializationMode", "manual").equals("manual")) {
            SemGraph semGraph = new SemGraph();
            semGraph.setShowErrorTerms(false);
            this.setSemGraph(semGraph);
        } else if (params.getString("newGraphInitializationMode", "manual").equals("random")) {
            this.setSemGraph(new SemGraph(GraphUtils.makeRandomGraph(this.getGraph(), this.parameters)));
        } else {
            this.setSemGraph(new SemGraph(GraphUtils.makeRandomGraph(this.getGraph(), this.parameters)));
        }
        this.parameters = params;
        this.log();
    }

    public SemGraphWrapper(SemGraphWrapper graphWrapper, Parameters params) {
        this.parameters = params;
        if (params.getString("newGraphInitializationMode", "manual").equals("manual")) {
            try {
                SemGraph semGraph = new SemGraph(graphWrapper.getSemGraph());
                semGraph.setShowErrorTerms(false);
                this.setSemGraph(semGraph);
            }
            catch (Exception e) {
                e.printStackTrace();
                SemGraph semGraph = new SemGraph();
                semGraph.setShowErrorTerms(false);
                this.setSemGraph(semGraph);
            }
        } else if (params.getString("newGraphInitializationMode", "manual").equals("random")) {
            this.setSemGraph(new SemGraph(GraphUtils.makeRandomGraph(this.getGraph(), this.parameters)));
        }
        this.log();
    }

    public SemGraphWrapper(DagWrapper graphWrapper, Parameters params) {
        this.parameters = params;
        if (params.getString("newGraphInitializationMode", "manual").equals("manual")) {
            SemGraph semGraph = new SemGraph(graphWrapper.getDag());
            semGraph.setShowErrorTerms(false);
            this.setSemGraph(semGraph);
        } else if (params.getString("newGraphInitializationMode", "manual").equals("random")) {
            this.setSemGraph(new SemGraph(GraphUtils.makeRandomGraph(this.getGraph(), this.parameters)));
        }
        this.log();
    }

    public SemGraphWrapper(GraphWrapper graphWrapper, Parameters params) {
        if (params.getString("newGraphInitializationMode", "manual").equals("manual")) {
            SemGraph semGraph = new SemGraph(graphWrapper.getGraph());
            semGraph.setShowErrorTerms(false);
            this.setSemGraph(semGraph);
        } else if (params.getString("newGraphInitializationMode", "manual").equals("random")) {
            this.setSemGraph(new SemGraph(GraphUtils.makeRandomGraph(this.getGraph(), this.parameters)));
        }
        this.parameters = params;
        this.log();
    }

    public SemGraphWrapper(AbstractAlgorithmRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public SemGraphWrapper(DataWrapper wrapper) {
        if (wrapper instanceof Simulation) {
            Simulation simulation = (Simulation)wrapper;
            this.graphs = new ArrayList<Graph>();
            for (Graph graph : simulation.getGraphs()) {
                SemGraph semGraph = new SemGraph(graph);
                semGraph.setShowErrorTerms(false);
                this.graphs.add(semGraph);
            }
            this.numModels = this.graphs.size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        } else {
            this.setGraph(new EdgeListGraph(wrapper.getVariables()));
        }
        LayoutUtil.circleLayout(this.getGraph(), 200, 200, 150);
    }

    public SemGraphWrapper(BayesPmWrapper wrapper) {
        this(new SemGraph(wrapper.getBayesPm().getDag()));
    }

    public SemGraphWrapper(BayesImWrapper wrapper) {
        this(new SemGraph(wrapper.getBayesIm().getBayesPm().getDag()));
    }

    public SemGraphWrapper(BayesEstimatorWrapper wrapper) {
        this(new SemGraph(wrapper.getEstimatedBayesIm().getBayesPm().getDag()));
    }

    public SemGraphWrapper(CptInvariantUpdaterWrapper wrapper) {
        this(new SemGraph(wrapper.getBayesUpdater().getManipulatedGraph()));
    }

    public SemGraphWrapper(SemPmWrapper wrapper) {
        this(new SemGraph(wrapper.getSemPm().getGraph()));
    }

    public SemGraphWrapper(SemImWrapper wrapper) {
        this(new SemGraph(wrapper.getSemIm().getSemPm().getGraph()));
    }

    public SemGraphWrapper(SemEstimatorWrapper wrapper) {
        this(new SemGraph(wrapper.getSemEstimator().getEstimatedSem().getSemPm().getGraph()));
    }

    public SemGraphWrapper(RegressionRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public SemGraphWrapper(BuildPureClustersRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public SemGraphWrapper(MimBuildRunner wrapper) {
        this(new SemGraph(wrapper.getResultGraph()));
    }

    public static SemGraphWrapper serializableInstance() {
        return new SemGraphWrapper(SemGraph.serializableInstance());
    }

    public SemGraph getSemGraph() {
        return (SemGraph)this.getGraph();
    }

    public void setSemGraph(SemGraph graph) {
        this.graphs = new ArrayList<Graph>();
        graph.setShowErrorTerms(false);
        this.graphs.add(graph);
        this.log();
    }

    private void log() {
        TetradLogger.getInstance().log("info", "Structural Equation Model (SEM) Graph");
        TetradLogger.getInstance().log("graph", "" + this.getGraph());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public Graph getGraph() {
        return this.graphs.get(this.getModelIndex());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    @Override
    public Map<String, String> getParamSettings() {
        HashMap<String, String> paramSettings = new HashMap<String, String>();
        if (!paramSettings.containsKey("# Vars")) {
            paramSettings.put("# Nodes", Integer.toString(this.getSemGraph().getNumNodes()));
        }
        paramSettings.put("# Edges", Integer.toString(this.getSemGraph().getNumEdges()));
        if (this.getSemGraph().paths().existsDirectedCycle()) {
            paramSettings.put("Cyclic", null);
        }
        return paramSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
        this.allParamSettings = paramSettings;
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return this.allParamSettings;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public void setNumModels(int numModels) {
        this.numModels = numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public void setModelSourceName(String modelSourceName) {
        this.modelSourceName = modelSourceName;
    }

    public void setGraph(Graph graph) {
        this.graphs = new ArrayList<Graph>();
        this.graphs.add(new SemGraph(graph));
        this.log();
    }

    @Override
    public List<Graph> getGraphs() {
        return this.graphs;
    }
}

