/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.simulation.LinearFisherModel;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.PValueImproverWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.SemUpdaterWrapper;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class SemImWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private List<SemIm> semIms;
    private String name;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;

    public SemImWrapper(SemIm semIm) {
        this.setSemIm(semIm);
    }

    public SemImWrapper(Simulation simulation) {
        if (simulation == null) {
            throw new NullPointerException("The Simulation box does not contain a simulation.");
        }
        edu.cmu.tetrad.algcomparison.simulation.Simulation _simulation = simulation.getSimulation();
        if (_simulation == null) {
            throw new NullPointerException("No data sets have been simulated.");
        }
        if (_simulation instanceof LinearFisherModel) {
            throw new IllegalArgumentException("Large SEM simulations cannot be represented using a SEM PM or IM box, sorry.");
        }
        if (!(_simulation instanceof SemSimulation)) {
            throw new IllegalArgumentException("That was not a linear, Gaussian SEM simulation. Sorry.");
        }
        this.semIms = ((SemSimulation)_simulation).getSemIms();
        if (this.semIms == null) {
            throw new NullPointerException("It looks like you have not done a simulation.");
        }
        this.numModels = simulation.getDataModelList().size();
        this.modelIndex = 0;
        this.modelSourceName = simulation.getName();
    }

    public SemImWrapper(SemPmWrapper semPmWrapper, Parameters params) {
        if (semPmWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        this.setSemIm(new SemIm(semPmWrapper.getSemPms().get(semPmWrapper.getModelIndex()), params));
    }

    public SemImWrapper(SemPmWrapper semPmWrapper, SemImWrapper oldSemImWrapper, Parameters params) {
        if (semPmWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Parameters must not be null.");
        }
        SemPm semPm = new SemPm(semPmWrapper.getSemPm());
        SemIm oldSemIm = oldSemImWrapper.getSemIm();
        if (!params.getBoolean("retainPreviousValues", false)) {
            this.setSemIm(new SemIm(semPm, params));
        } else {
            this.setSemIm(new SemIm(semPm, oldSemIm, params));
        }
    }

    public SemImWrapper(SemUpdaterWrapper semUpdaterWrapper) {
        if (semUpdaterWrapper == null) {
            throw new NullPointerException("SemPmWrapper must not be null.");
        }
        this.setSemIm(semUpdaterWrapper.getSemUpdater().getUpdatedSemIm());
    }

    private void setSemIm(SemIm updatedSemIm) {
        this.semIms = new ArrayList<SemIm>();
        this.semIms.add(new SemIm(updatedSemIm));
        for (int i = 0; i < this.semIms.size(); ++i) {
            this.log(i, this.semIms.get(i));
        }
    }

    public SemImWrapper(PValueImproverWrapper wrapper) {
        SemIm oldSemIm = wrapper.getNewSemIm();
        this.setSemIm(oldSemIm);
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    public SemIm getSemIm() {
        return this.semIms.get(this.getModelIndex());
    }

    public Graph getGraph() {
        return this.getSemIm().getSemPm().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(int i, SemIm pm) {
        TetradLogger.getInstance().log("info", "Linear SEM IM");
        TetradLogger.getInstance().log("info", "IM # " + (i + 1));
        TetradLogger.getInstance().log("im", pm.toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public Graph getSourceGraph() {
        return this.getGraph();
    }

    public Graph getResultGraph() {
        return this.getGraph();
    }

    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }
}

