/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.simulation.LinearFisherModel;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.DagInCPDAGWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.PValueImproverWrapper;
import edu.cmu.tetradapp.model.ScoredGraphsWrapper;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SemPmWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;
    private String name;
    private List<SemPm> semPms;

    public SemPmWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.semPms = new ArrayList<SemPm>();
        this.semPms.add(new SemPm(graph));
        for (int i = 0; i < this.semPms.size(); ++i) {
            this.log(i, this.semPms.get(i));
        }
    }

    public SemPmWrapper(Simulation simulation, Parameters parameters) {
        List<SemIm> semIms = null;
        if (simulation == null) {
            throw new NullPointerException("The Simulation box does not contain a simulation.");
        }
        edu.cmu.tetrad.algcomparison.simulation.Simulation _simulation = simulation.getSimulation();
        if (_simulation == null) {
            throw new NullPointerException("No data sets have been simulated.");
        }
        if (_simulation instanceof LinearFisherModel) {
            throw new IllegalArgumentException("Large SEM simulations cannot be represented using a SEM PM or IM box, sorry.");
        }
        if (!(_simulation instanceof SemSimulation)) {
            throw new IllegalArgumentException("That was not a linear, Gaussian SEM simulation.");
        }
        semIms = ((SemSimulation)_simulation).getSemIms();
        if (semIms == null) {
            throw new NullPointerException("It looks like you have not done a simulation.");
        }
        this.semPms = new ArrayList<SemPm>();
        for (SemIm semIm : semIms) {
            this.semPms.add(semIm.getSemPm());
        }
        this.numModels = simulation.getDataModelList().size();
        this.modelIndex = 0;
        this.modelSourceName = simulation.getName();
    }

    public SemPmWrapper(GraphSource graphWrapper, Parameters parameters) {
        this(graphWrapper.getGraph() instanceof TimeLagGraph ? new TimeLagGraph((TimeLagGraph)graphWrapper.getGraph()) : new EdgeListGraph(graphWrapper.getGraph()));
    }

    public SemPmWrapper(GraphSource graphSource, DataWrapper dataWrapper, Parameters parameters) {
        this(new EdgeListGraph(graphSource.getGraph()));
    }

    public SemPmWrapper(SemEstimatorWrapper wrapper, Parameters parameters) {
        SemPm oldSemPm = wrapper.getSemEstimator().getEstimatedSem().getSemPm();
        this.setSemPm(oldSemPm);
    }

    private void setSemPm(SemPm oldSemPm) {
        try {
            SemPm pm = new MarshalledObject<SemPm>(oldSemPm).get();
            this.semPms = Collections.singletonList(pm);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public SemPmWrapper(SemImWrapper wrapper) {
        SemPm pm = wrapper.getSemIm().getSemPm();
        this.setSemPm(pm);
    }

    public SemPmWrapper(MimBuildRunner wrapper) {
        SemPm pm = wrapper.getSemPm();
        this.setSemPm(pm);
    }

    public SemPmWrapper(BuildPureClustersRunner wrapper) {
        Graph graph = wrapper.getResultGraph();
        if (graph == null) {
            throw new IllegalArgumentException("No graph to display.");
        }
        SemPm pm = new SemPm(graph);
        this.setSemPm(pm);
    }

    public SemPmWrapper(Simulation simulation) {
        List<Graph> graphs = simulation.getGraphs();
        if (graphs.size() != 1) {
            throw new IllegalArgumentException("Simulation must contain exactly one graph/data pair.");
        }
        this.setSemPm(new SemPm(graphs.get(0)));
    }

    public SemPmWrapper(AlgorithmRunner wrapper) {
        this(new EdgeListGraph(wrapper.getGraph()));
    }

    public SemPmWrapper(DagInCPDAGWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getGraph()));
    }

    public SemPmWrapper(ScoredGraphsWrapper wrapper) {
        this(new EdgeListGraph(wrapper.getGraph()));
    }

    public SemPmWrapper(PValueImproverWrapper wrapper) {
        SemPm oldSemPm = wrapper.getNewSemIm().getSemPm();
        this.log(0, oldSemPm);
    }

    public static SemPmWrapper serializableInstance() {
        return new SemPmWrapper(Dag.serializableInstance());
    }

    public SemPm getSemPm() {
        return this.semPms.get(this.getModelIndex());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public Graph getGraph() {
        return this.semPms.get(this.modelIndex).getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(int i, SemPm pm) {
        TetradLogger.getInstance().log("info", "Linear Structural Equation Parametric Model (SEM PM)");
        TetradLogger.getInstance().log("info", "PM # " + (i + 1));
        TetradLogger.getInstance().log("pm", pm.toString());
    }

    public Graph getSourceGraph() {
        return this.getGraph();
    }

    public Graph getResultGraph() {
        return this.getResultGraph();
    }

    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public List<SemPm> getSemPms() {
        return this.semPms;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }
}

