/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.model.EditorUtils;
import edu.cmu.tetradapp.model.SessionNodeWrapper;
import edu.cmu.tetradapp.util.SessionWrapperIndirectRef;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class SessionWrapper
extends EdgeListGraph
implements SessionWrapperIndirectRef {
    static final long serialVersionUID = 23L;
    private final Session session;
    private final Set<Node> sessionNodeWrappers = new HashSet<Node>();
    private final Set<Edge> sessionEdges = new HashSet<Edge>();
    private transient PropertyChangeSupport propertyChangeSupport;
    private transient SessionHandler sessionHandler;
    private final boolean highlighted = false;
    private boolean pag;
    private boolean CPDAG;

    public SessionWrapper(Session session) {
        if (session == null) {
            throw new NullPointerException("Session must not be null.");
        }
        this.session = session;
        this.session.addSessionListener(this.getSessionHandler());
    }

    public static SessionWrapper serializableInstance() {
        return new SessionWrapper(Session.serializableInstance());
    }

    @Override
    public boolean addEdge(Edge edge) {
        SessionNodeWrapper from = (SessionNodeWrapper)Edges.getDirectedEdgeTail(edge);
        SessionNodeWrapper to = (SessionNodeWrapper)Edges.getDirectedEdgeHead(edge);
        SessionNode parent = from.getSessionNode();
        SessionNode child = to.getSessionNode();
        boolean added = child.addParent2(parent);
        if (added) {
            this.sessionEdges.add(edge);
            this.getPropertyChangeSupport().firePropertyChange("edgeAdded", null, edge);
            return true;
        }
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener e) {
        this.getPropertyChangeSupport().addPropertyChangeListener(e);
    }

    @Override
    public boolean addNode(Node node) {
        SessionNodeWrapper wrapper = (SessionNodeWrapper)node;
        SessionNode sessionNode = wrapper.getSessionNode();
        try {
            this.session.addNode(sessionNode);
            this.sessionNodeWrappers.add(node);
            this.getPropertyChangeSupport().firePropertyChange("nodeAdded", null, node);
            return true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void pasteSubsession(List sessionElements, Point upperLeft) {
        ArrayList<SessionNode> sessionNodes = new ArrayList<SessionNode>();
        ArrayList<SessionNodeWrapper> sessionNodeWrappers = new ArrayList<SessionNodeWrapper>();
        ArrayList<Edge> sessionEdges = new ArrayList<Edge>();
        Point oldUpperLeft = EditorUtils.getTopLeftPoint(sessionElements);
        int deltaX = upperLeft.x - oldUpperLeft.x;
        int deltaY = upperLeft.y - oldUpperLeft.y;
        for (Object e : sessionElements) {
            if (e instanceof SessionNodeWrapper) {
                SessionNodeWrapper wrapper = (SessionNodeWrapper)e;
                sessionNodeWrappers.add(wrapper);
                this.adjustNameAndPosition(wrapper, sessionNodeWrappers, deltaX, deltaY);
                SessionNode sessionNode = wrapper.getSessionNode();
                sessionNodes.add(sessionNode);
                continue;
            }
            if (e instanceof Edge) {
                sessionEdges.add((Edge)e);
                continue;
            }
            throw new IllegalArgumentException("The list of session elements should contain only SessionNodeWrappers and SessionEdges: " + e);
        }
        try {
            this.session.addNodeList(sessionNodes);
        }
        catch (Exception e) {
            throw new RuntimeException("There was an error when trying to add session nodes to the session.", e);
        }
        this.sessionNodeWrappers.addAll(sessionNodeWrappers);
        this.sessionEdges.addAll(sessionEdges);
        for (Object e : sessionNodeWrappers) {
            Node node = (Node)e;
            this.getPropertyChangeSupport().firePropertyChange("nodeAdded", null, node);
        }
        for (Object e : sessionEdges) {
            Edge edge = (Edge)e;
            this.getPropertyChangeSupport().firePropertyChange("edgeAdded", null, edge);
        }
    }

    private SessionHandler getSessionHandler() {
        if (this.sessionHandler == null) {
            this.sessionHandler = new SessionHandler();
        }
        return this.sessionHandler;
    }

    private void adjustNameAndPosition(SessionNodeWrapper wrapper, List sessionNodeWrappers, int deltaX, int deltaY) {
        String originalName = wrapper.getSessionName();
        String base = this.extractBase(originalName);
        String uniqueName = this.nextUniqueName(base, sessionNodeWrappers);
        if (!uniqueName.equals(originalName)) {
            wrapper.setSessionName(uniqueName);
            wrapper.setCenterX(wrapper.getCenterX() + deltaX);
            wrapper.setCenterY(wrapper.getCenterY() + deltaY);
        }
    }

    private String extractBase(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        StringBuilder buffer = new StringBuilder(name);
        for (int i = buffer.length() - 1; i >= 0; --i) {
            if (Character.isDigit(buffer.charAt(i))) continue;
            return buffer.substring(0, i + 1);
        }
        return "Node";
    }

    private String nextUniqueName(String base, List sessionNodeWrappers) {
        if (base == null) {
            throw new NullPointerException("Base name must be non-null.");
        }
        int i = 0;
        block0: while (true) {
            SessionNodeWrapper wrapper;
            Iterator<Node> iterator;
            String name = base + ++i;
            Iterator<Node> j = iterator = this.sessionNodeWrappers.iterator();
            while (j.hasNext()) {
                wrapper = (SessionNodeWrapper)j.next();
                if (!wrapper.getSessionName().equals(name)) continue;
                continue block0;
            }
            j = iterator = sessionNodeWrappers.iterator();
            while (j.hasNext()) {
                wrapper = (SessionNodeWrapper)j.next();
                if (!wrapper.getSessionName().equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o == this;
    }

    @Override
    public Set<Edge> getEdges() {
        return new HashSet<Edge>(this.sessionEdges);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        return null;
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        return null;
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.sessionEdges.contains(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.sessionNodeWrappers.contains(node);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        LinkedList<Edge> edgeList = new LinkedList<Edge>();
        for (Edge edge : this.sessionEdges) {
            if (edge.getNode1() != node && edge.getNode2() != node) continue;
            edgeList.add(edge);
        }
        return edgeList;
    }

    @Override
    public Node getNode(String name) {
        for (Node sessionNodeWrapper : this.sessionNodeWrappers) {
            SessionNodeWrapper wrapper = (SessionNodeWrapper)sessionNodeWrapper;
            if (!wrapper.getSessionName().equals(name)) continue;
            return wrapper;
        }
        return null;
    }

    @Override
    public int getNumNodes() {
        return this.sessionNodeWrappers.size();
    }

    @Override
    public int getNumEdges() {
        return this.sessionEdges.size();
    }

    @Override
    public int getNumEdges(Node node) {
        HashSet<Edge> edgeSet = new HashSet<Edge>();
        for (Edge edge : this.sessionEdges) {
            if (edge.getNode1() != node && edge.getNode2() != node) continue;
            edgeSet.add(edge);
        }
        return edgeSet.size();
    }

    @Override
    public List<Node> getNodes() {
        return new ArrayList<Node>(this.sessionNodeWrappers);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        if (this.sessionEdges.contains(edge)) {
            SessionNodeWrapper nodeAWrapper = (SessionNodeWrapper)edge.getNode1();
            SessionNodeWrapper nodeBWrapper = (SessionNodeWrapper)edge.getNode2();
            SessionNode nodeA = nodeAWrapper.getSessionNode();
            SessionNode nodeB = nodeBWrapper.getSessionNode();
            boolean removed = nodeB.removeParent(nodeA);
            if (removed) {
                this.sessionEdges.remove(edge);
                this.getPropertyChangeSupport().firePropertyChange("edgeRemoved", edge, null);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void removePropertyChangeListener(PropertyChangeListener e) {
        this.getPropertyChangeSupport().removePropertyChangeListener(e);
    }

    @Override
    public boolean removeNode(Node node) {
        if (this.sessionNodeWrappers.contains(node)) {
            for (Edge edge : this.getEdges(node)) {
                this.removeEdge(edge);
            }
            SessionNodeWrapper wrapper = (SessionNodeWrapper)node;
            SessionNode sessionNode = wrapper.getSessionNode();
            try {
                this.session.removeNode(sessionNode);
                this.sessionNodeWrappers.remove(wrapper);
                this.getPropertyChangeSupport().firePropertyChange("nodeRemoved", node, null);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public boolean removeNodes(List newNodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeEdges(Collection<Edge> edges) {
        boolean removed = false;
        for (Edge edge : edges) {
            removed = removed || this.removeEdge(edge);
        }
        return removed;
    }

    @Override
    public boolean removeEdges(Node nodeA, Node nodeB) {
        boolean removed = false;
        for (Edge edge : this.getEdges()) {
            if (edge.getNode1() != nodeA || edge.getNode2() != nodeB) continue;
            removed = removed || this.removeEdge(edge);
        }
        return true;
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        return this.getEdge(node1, node2).getProximalEndpoint(node2);
    }

    @Override
    public boolean setEndpoint(Node from, Node to, Endpoint endPoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "Wrapper for " + this.session.toString();
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getNodeNames() {
        throw new UnsupportedOperationException();
    }

    public boolean existsInducingPath(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    public Graph subgraph(List nodes) {
        throw new UnsupportedOperationException();
    }

    public Session getSession() {
        return this.session;
    }

    public String getName() {
        return this.session.getName();
    }

    public void setName(String name) {
        String oldName = this.session.getName();
        this.session.setName(name);
        this.propertyChangeSupport.firePropertyChange("name", oldName, this.session.getName());
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Node> getParents(Node node) {
        return new ArrayList<Node>(((SessionNode)node).getParents());
    }

    public boolean isSessionChanged() {
        return this.session.isSessionChanged();
    }

    public void setSessionChanged(boolean sessionChanged) {
        this.session.setSessionChanged(sessionChanged);
    }

    public boolean isNewSession() {
        return this.session.isNewSession();
    }

    public void setNewSession(boolean newSession) {
        this.session.setNewSession(newSession);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.session == null) {
            throw new NullPointerException();
        }
        if (this.sessionNodeWrappers == null) {
            throw new NullPointerException();
        }
        if (this.sessionEdges == null) {
            throw new NullPointerException();
        }
    }

    private static class SessionHandler
    extends SessionAdapter {
        private SessionHandler() {
        }

        @Override
        public void addingEdge(SessionEvent event) {
            String message = "Child node already created. If you add this edge,\nthe content of the child node will be made\nconsistent with the parent.";
            int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Child node already created. If you add this edge,\nthe content of the child node will be made\nconsistent with the parent.", "Warning", 2);
            if (ret == 2) {
                SessionNode sessionNode = (SessionNode)event.getSource();
                sessionNode.setNextEdgeAddAllowed(false);
            }
        }
    }
}

