/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.graph.SingleGraph;
import edu.cmu.tetrad.algcomparison.simulation.BayesNetSimulation;
import edu.cmu.tetrad.algcomparison.simulation.GeneralSemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.LinearFisherModel;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.SimulationUtils;
import edu.cmu.tetrad.algcomparison.simulation.StandardizedSemSimulation;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesImWrapperObs;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemImWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemPmWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.MultipleGraphSource;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.SemUpdaterWrapper;
import edu.cmu.tetradapp.model.StandardizedSemImWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Simulation
extends DataWrapper
implements GraphSource,
MultipleGraphSource {
    static final long serialVersionUID = 23L;
    private edu.cmu.tetrad.algcomparison.simulation.Simulation simulation;
    private Parameters parameters;
    private String name;
    private boolean fixedGraph = true;
    private boolean fixedSimulation = true;
    private List<DataModel> inputDataModelList;

    private Simulation() {
    }

    public Simulation(Parameters parameters) {
        if (this.simulation == null) {
            this.parameters = parameters;
            this.fixedGraph = false;
            this.fixedSimulation = false;
        }
    }

    public Simulation(GraphSource graphSource, Parameters parameters) {
        if (graphSource instanceof Simulation) {
            Simulation simulation = (Simulation)graphSource;
            this.simulation = simulation.simulation;
            this.parameters = new Parameters(simulation.parameters);
            this.name = simulation.name + ".copy";
            this.fixedGraph = simulation.fixedGraph;
            this.fixedSimulation = simulation.fixedSimulation;
            this.createSimulation();
        } else {
            this.fixedGraph = true;
            this.parameters = parameters;
            this.fixedSimulation = false;
            this.setSourceGraph(graphSource.getGraph());
            if (parameters.getParametersNames().contains("simulationsDropdownPreference")) {
                String simulationType = String.valueOf(parameters.getValues("simulationsDropdownPreference")[0]);
                this.simulation = SimulationUtils.create(simulationType, new SingleGraph(graphSource.getGraph()));
                this.createSimulation();
            } else {
                this.simulation = new BayesNetSimulation(new SingleGraph(graphSource.getGraph()));
            }
        }
    }

    public Simulation(BayesImWrapper wrapper, Parameters parameters) {
        this.simulation = new BayesNetSimulation(wrapper.getBayesIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(BayesImWrapperObs wrapper, Parameters parameters) {
        this.simulation = new BayesNetSimulation(wrapper.getBayesIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(BayesPmWrapper wrapper, Parameters parameters) {
        this.simulation = new BayesNetSimulation(wrapper.getBayesPm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(BayesEstimatorWrapper wrapper, Parameters parameters) {
        this.simulation = new BayesNetSimulation(wrapper.getEstimatedBayesIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(DirichletBayesImWrapper wrapper, Parameters parameters) {
        this.simulation = new BayesNetSimulation(wrapper.getDirichletBayesIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(DirichletEstimatorWrapper wrapper, Parameters parameters) {
        this.simulation = new BayesNetSimulation(wrapper.getEstimatedBayesIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(CptInvariantUpdaterWrapper wrapper, Parameters parameters) {
        this.simulation = new BayesNetSimulation(wrapper.getBayesUpdater().getManipulatedBayesIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(SemPmWrapper wrapper, Parameters parameters) {
        this.simulation = new SemSimulation(wrapper.getSemPm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(SemImWrapper wrapper, Parameters parameters) {
        this.simulation = new SemSimulation(wrapper.getSemIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(StandardizedSemImWrapper wrapper, Parameters parameters) {
        this.simulation = new StandardizedSemSimulation(wrapper.getStandardizedSemIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(SemEstimatorWrapper wrapper, Parameters parameters) {
        this.simulation = new SemSimulation(wrapper.getEstimatedSemIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(SemUpdaterWrapper wrapper, Parameters parameters) {
        this.simulation = new SemSimulation(wrapper.getSemUpdater().getManipulatedSemIm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(GeneralizedSemPmWrapper wrapper, Parameters parameters) {
        this.simulation = new GeneralSemSimulation(wrapper.getSemPm());
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(GeneralizedSemImWrapper wrapper, Parameters parameters) {
        if (wrapper.getSemIms().size() != 1) {
            throw new IllegalArgumentException("I'm sorry; this editor can only edit a single generalized SEM IM.");
        }
        this.simulation = new GeneralSemSimulation(wrapper.getSemIms().get(0));
        this.parameters = parameters;
        this.createSimulation();
    }

    public Simulation(DataWrapper dataWrapper, Parameters parameters) {
        if (this.simulation == null) {
            this.simulation = new LinearFisherModel(new RandomForward(), dataWrapper.getDataModelList());
            this.inputDataModelList = dataWrapper.getDataModelList();
            this.parameters = parameters;
            this.fixedGraph = false;
            this.fixedSimulation = false;
        }
    }

    public edu.cmu.tetrad.algcomparison.simulation.Simulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(edu.cmu.tetrad.algcomparison.simulation.Simulation simulation, Parameters parameters) {
        this.simulation = simulation;
        this.parameters = parameters;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Parameters getParams() {
        return this.parameters;
    }

    @Override
    public void setDataModel(DataModel dataModel) {
    }

    @Override
    public DataModelList getDataModelList() {
        DataModelList list = new DataModelList();
        for (int i = 0; i < this.simulation.getNumDataModels(); ++i) {
            list.add(this.simulation.getDataModel(i));
        }
        return list;
    }

    @Override
    public List<DataModel> getDataModels() {
        ArrayList<DataModel> list = new ArrayList<DataModel>();
        for (int i = 0; i < this.simulation.getNumDataModels(); ++i) {
            list.add(this.simulation.getDataModel(i));
        }
        return list;
    }

    @Override
    public void setDataModelList(DataModelList dataModelList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public Map<String, String> getParamSettings() {
        return new HashMap<String, String>();
    }

    public void createSimulation() {
        this.simulation.createData(this.parameters, false);
    }

    @Override
    public List<Graph> getGraphs() {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (int i = 0; i < this.simulation.getNumDataModels(); ++i) {
            graphs.add(this.simulation.getTrueGraph(i));
        }
        return graphs;
    }

    public boolean isFixedSimulation() {
        return this.fixedSimulation;
    }

    public void setFixedSimulation(boolean fixedSimulation) {
        this.fixedSimulation = fixedSimulation;
    }

    public boolean isFixedGraph() {
        return this.fixedGraph;
    }

    public void setFixedGraph(boolean fixedGraph) {
        this.fixedGraph = fixedGraph;
    }

    @Override
    public Knowledge getKnowledge() {
        if (this.simulation instanceof HasKnowledge) {
            return ((HasKnowledge)((Object)this.simulation)).getKnowledge();
        }
        return new Knowledge();
    }

    public void setSimulation(edu.cmu.tetrad.algcomparison.simulation.Simulation simulation) {
        this.simulation = simulation;
    }

    public List<DataModel> getInputDataModelList() {
        return this.inputDataModelList;
    }

    @Override
    public Graph getGraph() {
        HashSet<Graph> graphs = new HashSet<Graph>(this.getGraphs());
        if (graphs.size() == 1) {
            return (Graph)graphs.iterator().next();
        }
        throw new IllegalArgumentException("Expecting one graph.");
    }
}

