/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.Statistic;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleFalsePositive;
import edu.cmu.tetrad.algcomparison.statistic.TwoCyclePrecision;
import edu.cmu.tetrad.algcomparison.statistic.TwoCycleRecall;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.session.SimulationParamsSource;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TabularComparison
implements SessionModel,
SimulationParamsSource,
DoNotAddOldModel {
    static final long serialVersionUID = 23L;
    private final Graph targetGraph;
    private final Graph referenceGraph;
    private final Parameters params;
    private final DataModel dataModel = null;
    private String name;
    private Map<String, String> allParamSettings;
    private DataSet dataSet;
    private ArrayList<Statistic> statistics;
    private String targetName;
    private String referenceName;

    public TabularComparison(GraphSource model1, GraphSource model2, Parameters params) {
        this(model1, model2, null, params);
    }

    public TabularComparison(GraphSource model1, GraphSource model2, DataWrapper dataWrapper, Parameters params) {
        if (params == null) {
            throw new NullPointerException("Parameters must not be null");
        }
        if (model1 == null || model2 == null) {
            throw new NullPointerException("Null graph source>");
        }
        this.params = params;
        this.referenceName = params.getString("referenceGraphName", null);
        this.targetName = params.getString("targetGraphName", null);
        String model1Name = model1.getName();
        String model2Name = model2.getName();
        if (this.referenceName.equals(model1Name)) {
            this.referenceGraph = model1.getGraph();
            this.targetGraph = model2.getGraph();
        } else if (this.referenceName.equals(model2Name)) {
            this.referenceGraph = model2.getGraph();
            this.targetGraph = model1.getGraph();
        } else {
            this.referenceGraph = model1.getGraph();
            this.targetGraph = model2.getGraph();
        }
        this.newExecution();
        TetradLogger.getInstance().log("info", "Graph Comparison");
    }

    private void newExecution() {
        this.statistics = new ArrayList();
        this.statistics.add(new AdjacencyPrecision());
        this.statistics.add(new AdjacencyRecall());
        this.statistics.add(new ArrowheadPrecision());
        this.statistics.add(new ArrowheadRecall());
        this.statistics.add(new TwoCyclePrecision());
        this.statistics.add(new TwoCycleRecall());
        this.statistics.add(new TwoCycleFalsePositive());
        ArrayList<Node> variables = new ArrayList<Node>();
        for (Statistic statistic : this.statistics) {
            variables.add(new ContinuousVariable(statistic.getAbbreviation()));
        }
        this.dataSet = new BoxDataSet(new DoubleDataBox(0, variables.size()), variables);
        this.dataSet.setNumberFormat(new DecimalFormat("0.00"));
    }

    private void addRecord() {
        int newRow = this.dataSet.getNumRows();
        for (int j = 0; j < this.statistics.size(); ++j) {
            Statistic statistic = this.statistics.get(j);
            double value = statistic.getValue(this.referenceGraph, this.targetGraph, null);
            this.dataSet.setDouble(newRow, j, value);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public Map<String, String> getParamSettings() {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return this.allParamSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
        this.allParamSettings = new LinkedHashMap<String, String>(paramSettings);
    }

    public Graph getReferenceGraph() {
        return this.referenceGraph;
    }

    public Graph getTargetGraph() {
        return this.targetGraph;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public Parameters getParams() {
        return this.params;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }
}

