/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TimeLagGraphWrapper
implements GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private TimeLagGraph graph;
    private Parameters parameters;

    public TimeLagGraphWrapper(Parameters parameters) {
        this.graph = new TimeLagGraph();
        this.parameters = parameters;
        this.log();
    }

    public TimeLagGraphWrapper(TimeLagGraph graph, Parameters parameters) {
        if (graph == null) {
            throw new NullPointerException("Tetrad dag must not be null.");
        }
        this.graph = graph;
        this.parameters = parameters;
        this.log();
    }

    public TimeLagGraphWrapper(GraphWrapper graphWrapper) {
        String tmp;
        String varName;
        if (graphWrapper == null) {
            throw new NullPointerException("No graph wrapper.");
        }
        this.parameters = graphWrapper.getParameters();
        TimeLagGraph graph = new TimeLagGraph();
        Graph _graph = graphWrapper.getGraph();
        for (Node node : _graph.getNodes()) {
            Node _node = node.like(node.getName() + ":0");
            _node.setNodeType(node.getNodeType());
            graph.addNode(_node);
        }
        for (Edge edge : _graph.getEdges()) {
            if (!Edges.isDirectedEdge(edge)) {
                throw new IllegalArgumentException();
            }
            Node from = edge.getNode1();
            Node to = edge.getNode2();
            Node _from = graph.getNode(from.getName(), 1);
            Node _to = graph.getNode(to.getName(), 0);
            graph.addDirectedEdge(_from, _to);
        }
        this.graph = graph;
        int numLags = 1;
        List<Node> variables = graph.getNodes();
        ArrayList<Integer> laglist = new ArrayList<Integer>();
        Knowledge knowledge1 = new Knowledge();
        for (Node node : variables) {
            int lag;
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            laglist.add(lag);
        }
        numLags = (Integer)Collections.max(laglist);
        for (Node node : variables) {
            int lag;
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            laglist.add(lag);
            knowledge1.addToTier(numLags - lag, node.getName());
        }
        System.out.println("Knowledge in graph = " + knowledge1);
    }

    public TimeLagGraphWrapper() {
        this.graph = new TimeLagGraph();
        this.log();
    }

    public static TimeLagGraphWrapper serializableInstance() {
        return new TimeLagGraphWrapper(new TimeLagGraph(), new Parameters());
    }

    private void log() {
        TetradLogger.getInstance().log("info", "Directed Acyclic Graph (DAG)");
        TetradLogger.getInstance().log("graph", this.graph + "");
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.graph == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    public void setGraph(TimeLagGraph graph) {
        this.graph = graph;
    }

    public Knowledge getKnowledge() {
        String tmp;
        int lag;
        String varName;
        int numLags = 1;
        List<Node> variables = this.graph.getNodes();
        ArrayList<Integer> laglist = new ArrayList<Integer>();
        Knowledge knowledge1 = new Knowledge();
        for (Node node : variables) {
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            laglist.add(lag);
        }
        numLags = (Integer)Collections.max(laglist);
        for (Node node : variables) {
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            laglist.add(lag);
            knowledge1.addToTier(numLags - lag, node.getName());
        }
        System.out.println("Knowledge in graph = " + knowledge1);
        return knowledge1;
    }

    public Parameters getParameters() {
        return this.parameters;
    }
}

