/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.TsDagToPag;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;

public class TsPagFromDagGraphWrapper
extends GraphWrapper
implements DoNotAddOldModel {
    static final long serialVersionUID = 23L;

    public TsPagFromDagGraphWrapper(GraphSource source, Parameters parameters) {
        this(source.getGraph());
    }

    public TsPagFromDagGraphWrapper(Graph graph) {
        super(new EdgeListGraph());
        try {
            new Dag(graph);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The source graph is not a DAG.");
        }
        TsDagToPag p = new TsDagToPag(graph);
        Graph pag = p.convert();
        this.setGraph(pag);
        TetradLogger.getInstance().log("info", "\nGenerating allow_latent_common_causes from DAG.");
        TetradLogger.getInstance().log("CPDAG", pag + "");
    }

    public static TsPagFromDagGraphWrapper serializableInstance() {
        return new TsPagFromDagGraphWrapper(EdgeListGraph.serializableInstance());
    }

    @Override
    public boolean allowRandomGraph() {
        return false;
    }
}

