/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;

public class UndirectedToBidirectedWrapper
extends GraphWrapper
implements DoNotAddOldModel {
    static final long serialVersionUID = 23L;

    public UndirectedToBidirectedWrapper(GraphSource source, Parameters parameters) {
        this(source.getGraph());
    }

    public UndirectedToBidirectedWrapper(Graph graph) {
        super(UndirectedToBidirectedWrapper.pickDagFromCPDAG(graph), "Make Bidirected Edges Undirected");
        TetradLogger.getInstance().log("graph", this.getGraph() + "");
    }

    public static UndirectedToBidirectedWrapper serializableInstance() {
        return new UndirectedToBidirectedWrapper(EdgeListGraph.serializableInstance());
    }

    private static Graph pickDagFromCPDAG(Graph graph) {
        return GraphUtils.undirectedToBidirected(graph);
    }

    @Override
    public boolean allowRandomGraph() {
        return false;
    }
}

