/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.SimpleDataLoader;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Ccd;
import edu.cmu.tetrad.search.IndTestCramerT;
import edu.cmu.tetrad.search.Pc;
import edu.pitt.dbmi.data.reader.Delimiter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class YeastPcCcdSearchWrapper {
    public static void main(String[] args) {
        int[][] yeastReg = new int[][]{{1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0}, {0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1}, {0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1}, {0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1}};
        ArrayList<String> listOfNames = new ArrayList<String>();
        DataSet cds = null;
        try {
            cds = SimpleDataLoader.loadContinuousData(new File(args[0]), "//", '\"', "*", true, Delimiter.TAB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String outfileprefix = args[1];
        String outverbosefile = outfileprefix + ".doc";
        String outsummaryfile = outfileprefix + ".xls";
        FileOutputStream s1 = null;
        FileOutputStream s2 = null;
        try {
            s1 = new FileOutputStream(outverbosefile);
        }
        catch (IOException e) {
            System.out.println("Cannot open file file " + outverbosefile);
            System.exit(0);
        }
        DataOutputStream d1 = new DataOutputStream(s1);
        try {
            s2 = new FileOutputStream(outsummaryfile);
        }
        catch (IOException e) {
            System.out.println("Cannot open file file " + outsummaryfile);
            System.exit(0);
        }
        DataOutputStream d2 = new DataOutputStream(s2);
        try {
            d2.writeBytes("File\tPC05 FP\tPC05 FN\tPC10 FP\tPC10 FN\tPC15 FP\t");
            d2.writeBytes("PC15 FN\tPC20 FP\tPC20 FN\tPC30 FP\tPC30 FN\t");
            d2.writeBytes("CCD05 FP\tCCD05 FN\tCCD10 FP\tCCD10 FN\tCCD 15 FP\t");
            d2.writeBytes("CCD15 FN\tCCD20 FP\tCCD20 FN\tCCD30 FP\tCCD 30 FN\n");
            int ngenes = Integer.parseInt(args[2]);
            Knowledge bk = new Knowledge();
            bk.addToTiersByVarNames(listOfNames);
            d1.writeBytes("\n \n**Results for data in file yeastTRN**\n \n");
            d1.writeBytes("  Acutal adj matrix: \n");
            YeastPcCcdSearchWrapper.printAdjMatrix(yeastReg, listOfNames, d1);
            int[] PC05Accuracy = YeastPcCcdSearchWrapper.PCAccuracy(0.05, ngenes, cds, bk, yeastReg, listOfNames, d1);
            int[] PC10Accuracy = YeastPcCcdSearchWrapper.PCAccuracy(0.1, ngenes, cds, bk, yeastReg, listOfNames, d1);
            int[] PC15Accuracy = YeastPcCcdSearchWrapper.PCAccuracy(0.15, ngenes, cds, bk, yeastReg, listOfNames, d1);
            int[] PC20Accuracy = YeastPcCcdSearchWrapper.PCAccuracy(0.2, ngenes, cds, bk, yeastReg, listOfNames, d1);
            int[] PC30Accuracy = YeastPcCcdSearchWrapper.PCAccuracy(0.3, ngenes, cds, bk, yeastReg, listOfNames, d1);
            int[] CCD05Accuracy = YeastPcCcdSearchWrapper.CcdAccuracy(0.05, ngenes, cds, yeastReg, listOfNames, d1);
            int[] CCD10Accuracy = YeastPcCcdSearchWrapper.CcdAccuracy(0.1, ngenes, cds, yeastReg, listOfNames, d1);
            int[] CCD15Accuracy = YeastPcCcdSearchWrapper.CcdAccuracy(0.15, ngenes, cds, yeastReg, listOfNames, d1);
            int[] CCD20Accuracy = YeastPcCcdSearchWrapper.CcdAccuracy(0.2, ngenes, cds, yeastReg, listOfNames, d1);
            int[] CCD30Accuracy = YeastPcCcdSearchWrapper.CcdAccuracy(0.3, ngenes, cds, yeastReg, listOfNames, d1);
            d2.writeBytes("yeastTRN \t");
            d2.writeBytes(PC05Accuracy[0] + "\t");
            d2.writeBytes(PC05Accuracy[1] + "\t");
            d2.writeBytes(PC10Accuracy[0] + "\t");
            d2.writeBytes(PC10Accuracy[1] + "\t");
            d2.writeBytes(PC15Accuracy[0] + "\t");
            d2.writeBytes(PC15Accuracy[1] + "\t");
            d2.writeBytes(PC20Accuracy[0] + "\t");
            d2.writeBytes(PC20Accuracy[1] + "\t");
            d2.writeBytes(PC30Accuracy[0] + "\t");
            d2.writeBytes(PC30Accuracy[1] + "\t");
            d2.writeBytes(CCD05Accuracy[0] + "\t");
            d2.writeBytes(CCD05Accuracy[1] + "\t");
            d2.writeBytes(CCD10Accuracy[0] + "\t");
            d2.writeBytes(CCD10Accuracy[1] + "\t");
            d2.writeBytes(CCD15Accuracy[0] + "\t");
            d2.writeBytes(CCD15Accuracy[1] + "\t");
            d2.writeBytes(CCD20Accuracy[0] + "\t");
            d2.writeBytes(CCD20Accuracy[1] + "\t");
            d2.writeBytes(CCD30Accuracy[0] + "\t");
            d2.writeBytes(CCD30Accuracy[1] + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int[] CcdAccuracy(double alpha, int ngenes, DataSet cds, int[][] yeastReg, List<String> names, DataOutputStream d) {
        int i;
        int[] falsePosNeg = new int[2];
        IndTestCramerT indTestCramerT = new IndTestCramerT(cds, alpha);
        Ccd ccd = new Ccd(indTestCramerT);
        Graph ccdModel = ccd.search();
        int falsePositives = 0;
        int falseNegatives = 0;
        int[][] ccdModelAdj = new int[ngenes][ngenes];
        int nvariables = names.size();
        for (i = 0; i < nvariables; ++i) {
            String namei = names.get(i);
            for (int j = 0; j < nvariables; ++j) {
                Node varj;
                String namej = names.get(j);
                ccdModelAdj[i][j] = 0;
                Node vari = indTestCramerT.getVariable(namei);
                if (!ccdModel.isAdjacentTo(vari, varj = indTestCramerT.getVariable(namej))) continue;
                ccdModelAdj[i][j] = 1;
            }
        }
        for (i = 0; i < ngenes; ++i) {
            for (int j = i; j < ngenes; ++j) {
                if (yeastReg[i][j] == 0 && ccdModelAdj[i][j] == 1) {
                    ++falsePositives;
                }
                if (yeastReg[i][j] != 1 || ccdModelAdj[i][j] != 0) continue;
                ++falseNegatives;
            }
        }
        falsePosNeg[0] = falsePositives;
        falsePosNeg[1] = falseNegatives;
        try {
            d.writeBytes("\n \n");
            d.writeBytes("  Results of CCD search with alpha = " + alpha);
            d.writeBytes("  false+ " + falsePositives + "\t");
            d.writeBytes("false- " + falseNegatives + "\n");
            d.writeBytes("  Adjacency matrix of estimated model:  \n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        YeastPcCcdSearchWrapper.printAdjMatrix(ccdModelAdj, names, d);
        return falsePosNeg;
    }

    private static int[] PCAccuracy(double alpha, int ngenes, DataSet cds, Knowledge bk, int[][] yeastReg, List<String> names, DataOutputStream d) {
        int i;
        int[] falsePosNeg = new int[2];
        IndTestCramerT indTestCramerT = new IndTestCramerT(cds, alpha);
        Pc pcs = new Pc(indTestCramerT);
        pcs.setKnowledge(bk);
        Graph pcModel = pcs.search();
        int falsePositives = 0;
        int falseNegatives = 0;
        int[][] pcModelAdj = new int[ngenes][ngenes];
        int nvariables = names.size();
        for (i = 0; i < nvariables; ++i) {
            String namei = names.get(i);
            for (int j = 0; j < nvariables; ++j) {
                Node varj;
                String namej = names.get(j);
                pcModelAdj[i][j] = 0;
                Node vari = indTestCramerT.getVariable(namei);
                if (!pcModel.isAdjacentTo(vari, varj = indTestCramerT.getVariable(namej))) continue;
                pcModelAdj[i][j] = 1;
            }
        }
        for (i = 0; i < ngenes; ++i) {
            for (int j = i; j < ngenes; ++j) {
                if (yeastReg[i][j] == 0 && pcModelAdj[i][j] == 1) {
                    ++falsePositives;
                }
                if (yeastReg[i][j] != 1 || pcModelAdj[i][j] != 0) continue;
                ++falseNegatives;
            }
        }
        falsePosNeg[0] = falsePositives;
        falsePosNeg[1] = falseNegatives;
        try {
            d.writeBytes("\n \n");
            d.writeBytes("  Results of PC search with alpha = " + alpha);
            d.writeBytes("  false+ " + falsePositives + "\t");
            d.writeBytes("false- " + falseNegatives + "\n");
            d.writeBytes("  Adjacency matrix of estimated model:  \n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        YeastPcCcdSearchWrapper.printAdjMatrix(pcModelAdj, names, d);
        return falsePosNeg;
    }

    private static void printAdjMatrix(int[][] adjMat, List<String> listOfNames, DataOutputStream d) {
        for (int i = 0; i < adjMat.length; ++i) {
            try {
                d.writeBytes("  " + listOfNames.get(i) + "\t");
                for (int j = 0; j <= i; ++j) {
                    d.writeBytes(adjMat[i][j] + "\t");
                }
                d.writeBytes("\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

