/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class ArResidualsWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ArResidualsWrapper(DataWrapper data, Parameters params) {
        DataModelList list = data.getDataModelList();
        DataModelList convertedList = new DataModelList();
        DataModelList dataSets = data.getDataModelList();
        for (int i = 0; i < list.size(); ++i) {
            DataModel selectedModel = dataSets.get(i);
            if (!(selectedModel instanceof DataSet)) continue;
            DataSet model = TimeSeriesUtils.ar2((DataSet)selectedModel, params.getInt("numTimeLags", 1));
            model.setKnowledge(selectedModel.getKnowledge());
            convertedList.add(model);
            this.setSourceGraph(data.getSourceGraph());
        }
        this.setDataModelList(convertedList);
        LogDataUtils.logDataModelList("Result data from an AR residual calculation.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

