/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import org.apache.commons.math3.util.FastMath;

public class BoxCoxWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    private BoxCoxWrapper(DataWrapper data, Parameters params) {
        DataModelList list = data.getDataModelList();
        DataModelList convertedList = new DataModelList();
        DataModelList dataSets = data.getDataModelList();
        for (int i = 0; i < list.size(); ++i) {
            DataModel selectedModel = dataSets.get(i);
            if (!(selectedModel instanceof DataSet)) continue;
            DataModel model = this.yeoJohnson((DataSet)selectedModel, params.getDouble("lambda", 0.0));
            convertedList.add(model);
            this.setSourceGraph(data.getSourceGraph());
        }
        this.setDataModelList(convertedList);
        LogDataUtils.logDataModelList("Result data from an AR residual calculation.", this.getDataModelList());
    }

    private DataModel boxCox(DataSet dataSet, double lambda) {
        BoxDataSet transformedData = new BoxDataSet(new VerticalDoubleDataBox(dataSet.getNumRows(), dataSet.getVariables().size()), dataSet.getVariables());
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                double y = dataSet.getDouble(i, j);
                double d2 = lambda == 0.0 ? FastMath.log(y) : (FastMath.pow(y, lambda) - 1.0) / lambda;
                transformedData.setDouble(i, j, d2);
            }
        }
        return transformedData;
    }

    private DataModel yeoJohnson(DataSet dataSet, double lambda) {
        BoxDataSet transformedData = new BoxDataSet(new DoubleDataBox(dataSet.getNumRows(), dataSet.getVariables().size()), dataSet.getVariables());
        for (int j = 0; j < dataSet.getNumColumns(); ++j) {
            for (int i = 0; i < dataSet.getNumRows(); ++i) {
                double d2;
                double y = dataSet.getDouble(i, j);
                if (lambda != 0.0 && y >= 0.0) {
                    d2 = (FastMath.pow(y + 1.0, lambda) - 1.0) / lambda;
                } else if (lambda == 0.0 && y >= 0.0) {
                    d2 = FastMath.log(y + 1.0);
                } else if (lambda != 2.0 && y < 0.0) {
                    d2 = (FastMath.pow(1.0 - y, 2.0 - lambda) - 1.0) / (lambda - 2.0);
                } else if (lambda == 2.0 && y < 0.0) {
                    d2 = -FastMath.log(1.0 - y);
                } else {
                    throw new IllegalStateException("Impossible state.");
                }
                transformedData.setDouble(i, j, d2);
            }
        }
        return transformedData;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

