/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.MultidataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.LinkedList;

public class ConcatenateDatasetsWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ConcatenateDatasetsWrapper(DataWrapper[] data, Parameters params) {
        this.construct(data);
    }

    private void construct(DataWrapper ... dataWrappers) {
        for (DataWrapper wrapper : dataWrappers) {
            if (wrapper != null) continue;
            throw new NullPointerException("The given data must not be null");
        }
        LinkedList<DataModel> dataModels = new LinkedList<DataModel>();
        for (DataWrapper wrapper : dataWrappers) {
            wrapper.getDataModelList().forEach(dataModel -> {
                if (!(dataModel instanceof DataSet)) {
                    throw new IllegalArgumentException("Sorry, I am only willing to concatenate tabular datasets.");
                }
                dataModels.add((DataModel)dataModel);
            });
        }
        DataModel dataModel2 = MultidataUtils.combineDataset(dataModels);
        dataModel2.setName("Concatenated");
        this.setDataModel(dataModel2);
        LogDataUtils.logDataModelList("Parent data in which constant columns have been removed.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

