/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class ConvertNumericalDiscreteToContinuousWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ConvertNumericalDiscreteToContinuousWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModelList dataSets = data.getDataModelList();
        DataModelList convertedDataSets = new DataModelList();
        for (DataModel dataModel : dataSets) {
            DataSet convertedData;
            if (!(dataModel instanceof DataSet)) {
                throw new IllegalArgumentException("Only tabular data sets can be converted to time lagged form.");
            }
            DataSet originalData = (DataSet)dataModel;
            try {
                convertedData = DataUtils.convertNumericalDiscreteToContinuous(originalData);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("There were some non-numeric values in that dataset.");
            }
            convertedDataSets.add(convertedData);
        }
        this.setDataModel(convertedDataSets);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Data in which numerical discrete columns of parent node data have been expanded.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

