/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CovMatrixAverageWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CovMatrixAverageWrapper(DataWrapper[] covs, Parameters params) {
        ArrayList<DataWrapper> matrices = new ArrayList<DataWrapper>(Arrays.asList(covs));
        this.calcAverage(matrices);
    }

    private void calcAverage(List<DataWrapper> wrappers) {
        ArrayList<Matrix> cov = new ArrayList<Matrix>();
        for (DataWrapper wrapper : wrappers) {
            DataModel selectedDataModel = wrapper.getSelectedDataModel();
            if (!(selectedDataModel instanceof ICovarianceMatrix)) {
                throw new IllegalArgumentException("Sorry, this is an average only over covariance matrices.");
            }
            cov.add(((ICovarianceMatrix)selectedDataModel).getMatrix());
        }
        Matrix cov3 = new Matrix(((Matrix)cov.get(0)).rows(), ((Matrix)cov.get(0)).rows());
        for (int i = 0; i < ((Matrix)cov.get(0)).rows(); ++i) {
            for (int j = 0; j < ((Matrix)cov.get(0)).rows(); ++j) {
                double c = 0.0;
                for (Matrix matrix : cov) {
                    c += matrix.get(i, j);
                }
                cov3.set(i, j, c /= (double)cov.size());
                cov3.set(j, i, c);
            }
        }
        DataModel m = wrappers.get(0).getSelectedDataModel();
        ICovarianceMatrix _cov = (ICovarianceMatrix)m;
        List<Node> nodes = _cov.getVariables();
        int n = _cov.getSampleSize();
        CovarianceMatrix covWrapper = new CovarianceMatrix(nodes, cov3, n);
        this.setDataModel(covWrapper);
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

