/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import org.apache.commons.math3.util.FastMath;

public class CovMatrixDifferenceWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CovMatrixDifferenceWrapper(DataWrapper wrapper1, DataWrapper wrapper2, Parameters params) {
        if (wrapper1 == null || wrapper2 == null) {
            throw new NullPointerException("The data must not be null");
        }
        DataModel model1 = wrapper1.getSelectedDataModel();
        DataModel model2 = wrapper2.getSelectedDataModel();
        if (!(model1 instanceof ICovarianceMatrix)) {
            throw new IllegalArgumentException("Expecting covariance matrices.");
        }
        if (!(model2 instanceof ICovarianceMatrix)) {
            throw new IllegalArgumentException("Expecting covariance matrices.");
        }
        Matrix corr1 = ((ICovarianceMatrix)model1).getMatrix();
        Matrix corr2 = ((ICovarianceMatrix)model2).getMatrix();
        Matrix corr3 = this.calcDifference(corr1, corr2);
        CovarianceMatrix covWrapper = new CovarianceMatrix(model1.getVariables(), corr3, ((ICovarianceMatrix)model1).getSampleSize());
        this.setDataModel(covWrapper);
        this.setSourceGraph(wrapper1.getSourceGraph());
        LogDataUtils.logDataModelList("Difference of matrices.", this.getDataModelList());
    }

    private Matrix calcDifference(Matrix corr1, Matrix corr2) {
        int i;
        if (corr1.rows() != corr2.rows()) {
            throw new IllegalArgumentException("Covariance matrices must be the same size.");
        }
        Matrix corr3 = new Matrix(corr2.rows(), corr2.rows());
        for (i = 0; i < corr3.rows(); ++i) {
            for (int j = 0; j < corr3.rows(); ++j) {
                double v = corr1.get(i, j) - corr2.get(i, j);
                corr3.set(i, j, v);
            }
        }
        for (i = 0; i < corr3.rows(); ++i) {
            corr3.set(i, i, FastMath.abs(corr3.get(i, i)));
        }
        return corr3;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

