/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class CovMatrixSumWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CovMatrixSumWrapper(DataWrapper wrapper1, DataWrapper wrapper2) {
        if (wrapper1 == null || wrapper2 == null) {
            throw new NullPointerException("The data must not be null");
        }
        DataModel model1 = wrapper1.getSelectedDataModel();
        DataModel model2 = wrapper2.getSelectedDataModel();
        if (!(model1 instanceof ICovarianceMatrix)) {
            throw new IllegalArgumentException("Expecting corrariance matrices.");
        }
        if (!(model2 instanceof ICovarianceMatrix)) {
            throw new IllegalArgumentException("Expecting corrariance matrices.");
        }
        Matrix corr1 = ((ICovarianceMatrix)model1).getMatrix();
        Matrix corr2 = ((ICovarianceMatrix)model2).getMatrix();
        Matrix corr3 = this.calcSum(corr1, corr2);
        CovarianceMatrix covWrapper = new CovarianceMatrix(model1.getVariables(), corr3, ((ICovarianceMatrix)model1).getSampleSize());
        this.setDataModel(covWrapper);
        this.setSourceGraph(wrapper1.getSourceGraph());
        LogDataUtils.logDataModelList("Difference of matrices.", this.getDataModelList());
    }

    private Matrix calcSum(Matrix corr1, Matrix corr2) {
        if (corr1.rows() != corr2.rows()) {
            throw new IllegalArgumentException("Covariance matrices must be the same size.");
        }
        Matrix corr3 = new Matrix(corr2.rows(), corr2.rows());
        for (int i = 0; i < corr3.rows(); ++i) {
            for (int j = 0; j < corr3.rows(); ++j) {
                double v = corr1.get(i, j) + corr2.get(i, j);
                corr3.set(i, j, v);
                corr3.set(j, i, v);
            }
        }
        return corr3;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

