/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class CovMatrixWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CovMatrixWrapper(DataWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModelList models = wrapper.getDataModelList();
        DataModelList out = new DataModelList();
        for (DataModel model : models) {
            if (model instanceof DataSet) {
                DataSet dataSet = (DataSet)model;
                if (!dataSet.isContinuous()) {
                    throw new IllegalArgumentException("The data must be continuous");
                }
                CovarianceMatrix covarianceMatrix = new CovarianceMatrix(dataSet);
                out.add(covarianceMatrix);
                continue;
            }
            if (!(model instanceof ICovarianceMatrix)) continue;
            CovarianceMatrix covarianceMatrix = new CovarianceMatrix((CovarianceMatrix)model);
            out.add(covarianceMatrix);
        }
        this.setDataModel(out);
        LogDataUtils.logDataModelList("Conversion of data to covariance matrix form.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

