/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Discretizer;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;

public class DiscretizationWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;
    private final List<DataSet> discretizedDataSets = null;

    public DiscretizationWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        if (params == null) {
            throw new NullPointerException("The given parameters must not be null");
        }
        DataModelList dataSets = data.getDataModelList();
        DataModelList discretizedDataSets = new DataModelList();
        for (DataModel dataModel : dataSets) {
            if (!(dataModel instanceof DataSet)) {
                throw new IllegalArgumentException("Only tabular data sets can be converted to time lagged form.");
            }
            DataSet originalData = (DataSet)dataModel;
            Map discretizationSpecs = (Map)params.get("discretizationSpecs", new HashMap());
            Discretizer discretizer = new Discretizer(originalData, discretizationSpecs);
            discretizer.setVariablesCopied(Preferences.userRoot().getBoolean("copyUnselectedColumns", true));
            discretizedDataSets.add(discretizer.discretize());
        }
        this.setDataModel(discretizedDataSets);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Discretization of data in the parent node.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

