/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class FirstDifferencesWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public FirstDifferencesWrapper(DataWrapper wrapper, Parameters params) {
        LogDataUtils.logDataModelList("Parent data in which rows have been randomly permuted.", this.getDataModelList());
        DataModelList inList = wrapper.getDataModelList();
        DataModelList outList = new DataModelList();
        for (DataModel model : inList) {
            if (!(model instanceof DataSet)) {
                throw new IllegalArgumentException("Not a data set: " + model.getName());
            }
            DataSet data = (DataSet)model;
            if (!data.isContinuous()) {
                throw new IllegalArgumentException("Not a continuous data set: " + data.getName());
            }
            BoxDataSet firstDiff = new BoxDataSet(new DoubleDataBox(data.getNumRows() - 1, data.getVariables().size()), data.getVariables());
            for (int j = 0; j < data.getNumColumns(); ++j) {
                for (int i = 0; i < data.getNumRows() - 1; ++i) {
                    double d2 = data.getDouble(i + 1, j);
                    double d1 = data.getDouble(i, j);
                    firstDiff.setDouble(i, j, d2 - d1);
                }
            }
            outList.add(firstDiff);
        }
        this.setDataModel(outList);
        this.setSourceGraph(wrapper.getSourceGraph());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

