/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class InverseMatrixWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public InverseMatrixWrapper(DataWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModel model = wrapper.getSelectedDataModel();
        if (model instanceof DataSet) {
            DataSet dataSet = (DataSet)model;
            if (!dataSet.isContinuous()) {
                throw new IllegalArgumentException("The data must be continuous");
            }
            Matrix _data = dataSet.getDoubleData();
            Matrix _data2 = _data.inverse();
            BoxDataSet inverse = new BoxDataSet(new DoubleDataBox(_data2.toArray()), dataSet.getVariables());
            this.setDataModel(inverse);
            this.setSourceGraph(wrapper.getSourceGraph());
        } else if (model instanceof ICovarianceMatrix) {
            ICovarianceMatrix cov = (ICovarianceMatrix)model;
            Matrix _data = cov.getMatrix();
            Matrix _data2 = _data.inverse();
            BoxDataSet inverse = new BoxDataSet(new DoubleDataBox(_data2.toArray()), cov.getVariables());
            this.setDataModel(inverse);
            this.setSourceGraph(wrapper.getSourceGraph());
        } else {
            throw new IllegalArgumentException("Must be a dataset or a covariance  matrix");
        }
        LogDataUtils.logDataModelList("Conversion of data to covariance matrix form.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

