/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class InvertCovMatrixWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public InvertCovMatrixWrapper(DataWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModel model = wrapper.getSelectedDataModel();
        if (!(model instanceof ICovarianceMatrix)) {
            throw new IllegalArgumentException("Must be a covariance matrix");
        }
        ICovarianceMatrix dataSet = (ICovarianceMatrix)model;
        Matrix data = dataSet.getMatrix();
        Matrix inverse = data.inverse();
        String[] varNames = dataSet.getVariableNames().toArray(new String[0]);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), inverse, ((ICovarianceMatrix)model).getSampleSize());
        this.setDataModel(covarianceMatrix);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogDataUtils.logDataModelList("Inverts a parent covaraince matrix.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

