/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class RemoveSelectedVariablesWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public RemoveSelectedVariablesWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The givan data must not be null");
        }
        DataModel model = data.getSelectedDataModel();
        if (model instanceof DataSet) {
            this.setDataModel(RemoveSelectedVariablesWrapper.createRectangularModel(((DataSet)model).copy()));
        } else if (model instanceof ICovarianceMatrix) {
            this.setDataModel(RemoveSelectedVariablesWrapper.createCovarianceModel((ICovarianceMatrix)model));
        } else {
            throw new IllegalArgumentException("Expecting a rectangular data set or a covariance matrix.");
        }
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Parent data restricted to selected variables only.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    private static DataModel createRectangularModel(DataSet data) {
        for (int i = data.getNumColumns() - 1; i >= 0; --i) {
            if (!data.isSelected(data.getVariable(i))) continue;
            data.removeColumn(i);
        }
        return data;
    }

    private static DataModel createCovarianceModel(ICovarianceMatrix data) {
        int numSelected = 0;
        for (Node node : data.getVariables()) {
            if (!data.isSelected(node)) continue;
            ++numSelected;
        }
        int[] selectedIndices = new int[numSelected];
        String[] nodeNames = new String[numSelected];
        int index = -1;
        for (int i = 0; i < data.getVariables().size(); ++i) {
            Node node = data.getVariables().get(i);
            if (data.isSelected(node)) continue;
            selectedIndices[++index] = i;
            nodeNames[index] = node.getName();
        }
        Matrix matrix = data.getMatrix();
        Matrix newMatrix = matrix.getSelection(selectedIndices, selectedIndices).copy();
        return new CovarianceMatrix(DataUtils.createContinuousVariables(nodeNames), newMatrix, data.getSampleSize());
    }
}

