/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.List;

public class ReorderColumnsWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ReorderColumnsWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The givan data must not be null");
        }
        DataModelList dataModelList = data.getDataModelList();
        List<Node> variables = dataModelList.get(0).getVariables();
        DataModelList newData = new DataModelList();
        variables = new ArrayList<Node>(variables);
        RandomUtil.shuffle(variables);
        if (dataModelList.get(0) instanceof DataSet) {
            ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
            for (DataModel dataModel : dataModelList) {
                dataSets.add((DataSet)dataModel);
            }
            newData.addAll(DataUtils.shuffleColumns2(dataSets));
        } else {
            for (DataModel dataModel : dataModelList) {
                if (!(dataModel instanceof CovarianceMatrix)) continue;
                CovarianceMatrix cov = (CovarianceMatrix)dataModel;
                ArrayList<String> vars = new ArrayList<String>();
                for (Node node : variables) {
                    vars.add(node.getName());
                }
                ICovarianceMatrix _newData = cov.getSubmatrix(vars);
                newData.add(_newData);
            }
        }
        this.setDataModel(newData);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Parent data in which constant columns have been removed.", this.getDataModelList());
    }

    public static DataSet shuffleColumns(DataSet dataModel) {
        ArrayList<Node> vars = new ArrayList<Node>();
        for (Node node : dataModel.getVariables()) {
            Node _node = dataModel.getVariable(node.getName());
            if (_node == null) continue;
            vars.add(_node);
        }
        RandomUtil.shuffle(vars);
        return dataModel.subsetColumns(vars);
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

