/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.regression.RegressionUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemGraphWrapper;

public class ResidualsWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ResidualsWrapper(DataWrapper data, DagWrapper dagWrapper, Parameters params) {
        DataModelList list = data.getDataModelList();
        DataModelList newList = new DataModelList();
        for (DataModel dataModel : list) {
            if (!(dataModel instanceof DataSet)) {
                throw new IllegalArgumentException("The data must be a rectangular dataset");
            }
            DataSet dataSet = (DataSet)dataModel;
            Graph dag = dagWrapper.getGraph();
            dataSet = RegressionUtils.residuals(dataSet, dag);
            newList.add(dataSet);
        }
        this.setDataModel(newList);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Parent data in which each column has been replaced by its regression residuals.", this.getDataModelList());
    }

    public ResidualsWrapper(DataWrapper data, GraphWrapper graphWrapper, Parameters params) {
        DataModelList list = data.getDataModelList();
        DataModelList newList = new DataModelList();
        for (DataModel dataModel : list) {
            if (!(dataModel instanceof DataSet)) {
                throw new IllegalArgumentException("The data must be a rectangular dataset");
            }
            DataSet dataSet = (DataSet)dataModel;
            Graph graph = graphWrapper.getGraph();
            dataSet = RegressionUtils.residuals(dataSet, graph);
            newList.add(dataSet);
        }
        this.setDataModel(newList);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Parent data in which each column has been replaced by its regression residuals.", this.getDataModelList());
    }

    public ResidualsWrapper(DataWrapper data, SemGraphWrapper wrapper, Parameters params) {
        DataModelList list = data.getDataModelList();
        DataModelList newList = new DataModelList();
        for (DataModel dataModel : list) {
            if (!(dataModel instanceof DataSet)) {
                throw new IllegalArgumentException("The data must be a rectangular dataset");
            }
            DataSet dataSet = (DataSet)dataModel;
            Graph graph = wrapper.getGraph();
            dataSet = RegressionUtils.residuals(dataSet, graph);
            newList.add(dataSet);
        }
        this.setDataModel(newList);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Parent data in which each column has been replaced by its regression residuals.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

