/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class ShiftDataWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public ShiftDataWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModelList dataModelList = data.getDataModelList();
        int rows = -1;
        int cols = -1;
        for (Object model : dataModelList) {
            if (!(model instanceof DataSet)) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "For the shift search, all of the data in the data box must be in the form of data sets.");
                return;
            }
            DataSet dataSet = (DataSet)model;
        }
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        for (DataModel dataModel : dataModelList) {
            dataSets.add((DataSet)dataModel);
        }
        int[] backshifts = (int[])params.get("shifts", null);
        if (backshifts.length < ((DataSet)dataSets.get(0)).getNumColumns()) {
            return;
        }
        List<DataSet> backshiftedDataSets = this.shiftDataSets(dataSets, backshifts);
        DataModelList _list = new DataModelList();
        _list.addAll(backshiftedDataSets);
        this.setDataModel(_list);
        this.setSourceGraph(data.getSourceGraph());
        params.set("shifts", (Object)backshifts);
        LogDataUtils.logDataModelList("Data in which variables have been shifted in time.", this.getDataModelList());
    }

    private List<DataSet> shiftDataSets(List<DataSet> dataSets, int[] shifts) {
        ArrayList<DataSet> shiftedDataSets = new ArrayList<DataSet>();
        for (DataSet dataSet : dataSets) {
            shiftedDataSets.add(TimeSeriesUtils.createShiftedData(dataSet, shifts));
        }
        return shiftedDataSets;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

