/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class SimulateFromCovWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public SimulateFromCovWrapper(DataWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException("The given data must not be null");
        }
        DataModel model = wrapper.getSelectedDataModel();
        if (!(model instanceof ICovarianceMatrix)) {
            throw new IllegalArgumentException("Must be a dataset or a covariance  matrix");
        }
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix((CovarianceMatrix)model);
        DataSet dataSet = DataUtils.choleskySimulation(covarianceMatrix);
        this.setDataModel(dataSet);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogDataUtils.logDataModelList("Conversion of data to covariance matrix form.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

