/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.data.SplitCasesSpec;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.List;

public class SplitCasesWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public SplitCasesWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        if (params == null) {
            throw new NullPointerException("The given parameters must not be null");
        }
        DataSet originalData = (DataSet)data.getSelectedDataModel();
        DataModel model = SplitCasesWrapper.createSplits(originalData, params);
        this.setDataModel(model);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("One split of the parent data.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    private static DataModel createSplits(DataSet dataSet, Parameters params) {
        ArrayList<Integer> indices = new ArrayList<Integer>(dataSet.getNumRows());
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            indices.add(i);
        }
        if (params.getBoolean("dataShuffled", true)) {
            RandomUtil.shuffle(indices);
        }
        SplitCasesSpec spec = (SplitCasesSpec)params.get("splitCasesSpec", null);
        int numSplits = params.getInt("numSplits", 3);
        int sampleSize = spec.getSampleSize();
        int[] breakpoints = spec.getBreakpoints();
        List<String> splitNames = spec.getSplitNames();
        int[] _breakpoints = new int[breakpoints.length + 2];
        _breakpoints[0] = 0;
        _breakpoints[_breakpoints.length - 1] = sampleSize;
        System.arraycopy(breakpoints, 0, _breakpoints, 1, breakpoints.length);
        DataModelList list = new DataModelList();
        int ncols = dataSet.getNumColumns();
        for (int n = 0; n < numSplits; ++n) {
            int _sampleSize = _breakpoints[n + 1] - _breakpoints[n];
            BoxDataSet _data = new BoxDataSet(new VerticalDoubleDataBox(_sampleSize, dataSet.getVariables().size()), dataSet.getVariables());
            _data.setName(splitNames.get(n));
            for (int i = 0; i < _sampleSize; ++i) {
                int oldCase = (Integer)indices.get(i + _breakpoints[n]);
                for (int j = 0; j < ncols; ++j) {
                    _data.setObject(i, j, dataSet.getObject(oldCase, j));
                }
            }
            list.add(_data);
        }
        return list;
    }
}

