/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model.datamanip;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.List;

public class SubsetContinuousVariablesWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public SubsetContinuousVariablesWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The givan data must not be null");
        }
        DataModel model = data.getSelectedDataModel();
        if (!(model instanceof DataSet)) {
            throw new IllegalArgumentException("The given dataset must be tabular");
        }
        this.setDataModel(SubsetContinuousVariablesWrapper.createModel((DataSet)model));
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Parent data restricted to continuous variables only.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    private static DataModel createModel(DataSet data) {
        List<Node> variables = data.getVariables();
        int n = 0;
        for (Node variable : variables) {
            if (!(variable instanceof ContinuousVariable)) continue;
            ++n;
        }
        if (n == 0) {
            return new BoxDataSet(new DoubleDataBox(0, 0), new ArrayList<Node>());
        }
        int[] indices = new int[n];
        int m = 0;
        for (int i = 0; i < variables.size(); ++i) {
            if (!(variables.get(i) instanceof ContinuousVariable)) continue;
            indices[m++] = i;
        }
        return data.subsetColumns(indices);
    }
}

