/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.ui.model;

import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.annotation.Algorithm;
import edu.cmu.tetrad.annotation.AnnotatedClass;
import edu.cmu.tetrad.util.AlgorithmDescriptions;
import java.io.Serializable;

public class AlgorithmModel
implements Serializable,
Comparable<AlgorithmModel> {
    private static final long serialVersionUID = 8599854464475682558L;
    private final AnnotatedClass<Algorithm> algorithm;
    private final String name;
    private final String description;
    private final boolean requiredScore;
    private final boolean requiredTest;

    public AlgorithmModel(AnnotatedClass<Algorithm> algorithm) {
        if (algorithm == null) {
            throw new IllegalArgumentException("Algorithm annotation cannot be null.");
        }
        this.algorithm = algorithm;
        this.name = algorithm.getAnnotation().name();
        this.description = AlgorithmDescriptions.getInstance().get(algorithm.getAnnotation().command());
        this.requiredScore = UsesScoreWrapper.class.isAssignableFrom(algorithm.getClazz());
        this.requiredTest = TakesIndependenceWrapper.class.isAssignableFrom(algorithm.getClazz());
    }

    @Override
    public int compareTo(AlgorithmModel other) {
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.name;
    }

    public AnnotatedClass<Algorithm> getAlgorithm() {
        return this.algorithm;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequiredScore() {
        return this.requiredScore;
    }

    public boolean isRequiredTest() {
        return this.requiredTest;
    }
}

