/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.ui.model;

import edu.cmu.tetrad.annotation.AlgType;
import edu.cmu.tetrad.annotation.AlgorithmAnnotations;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetradapp.Tetrad;
import edu.cmu.tetradapp.ui.model.AlgorithmModel;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class AlgorithmModels {
    private static final AlgorithmModels INSTANCE = new AlgorithmModels();
    private List<AlgorithmModel> models;
    private Map<AlgType, List<AlgorithmModel>> modelMap;

    private AlgorithmModels() {
        this.refreshModels();
    }

    private void refreshModels() {
        AlgorithmAnnotations algoAnno = AlgorithmAnnotations.getInstance();
        List list = Tetrad.enableExperimental ? algoAnno.getAnnotatedClasses() : algoAnno.filterOutExperimental(algoAnno.getAnnotatedClasses());
        this.models = Collections.unmodifiableList(list.stream().map(AlgorithmModel::new).sorted().collect(Collectors.toList()));
        EnumMap<AlgType, List> map = new EnumMap<AlgType, List>(AlgType.class);
        for (AlgType algType : AlgType.values()) {
            map.put(algType, new LinkedList());
        }
        this.models.forEach(e -> ((List)map.get((Object)e.getAlgorithm().getAnnotation().algoType())).add(e));
        map.forEach((k, v) -> map.put((AlgType)((Object)k), Collections.unmodifiableList(v)));
        this.modelMap = Collections.unmodifiableMap(map);
    }

    public static AlgorithmModels getInstance() {
        INSTANCE.refreshModels();
        return INSTANCE;
    }

    private List<AlgorithmModel> filterInclusivelyByAllOrSpecificDataType(List<AlgorithmModel> algorithmModels, DataType dataType, boolean multiDataSetAlgorithm) {
        AlgorithmAnnotations algoAnno = AlgorithmAnnotations.getInstance();
        return dataType == DataType.All ? algorithmModels : algorithmModels.stream().filter(e -> !multiDataSetAlgorithm || algoAnno.takesMultipleDataset(e.getAlgorithm().getClazz())).filter(e -> {
            for (DataType dt : e.getAlgorithm().getAnnotation().dataType()) {
                if (dt != DataType.All && dt != dataType) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public List<AlgorithmModel> getModels(DataType dataType, boolean multiDataSetAlgorithm) {
        return this.filterInclusivelyByAllOrSpecificDataType(this.models, dataType, multiDataSetAlgorithm);
    }

    public List<AlgorithmModel> getModels(AlgType algType, DataType dataType, boolean multiDataSetAlgorithm) {
        return this.modelMap.containsKey((Object)algType) ? this.filterInclusivelyByAllOrSpecificDataType(this.modelMap.get((Object)algType), dataType, multiDataSetAlgorithm) : Collections.EMPTY_LIST;
    }
}

