/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.ui.model;

import edu.cmu.tetrad.annotation.TestOfIndependenceAnnotations;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.util.TetradProperties;
import edu.cmu.tetradapp.Tetrad;
import edu.cmu.tetradapp.ui.model.IndependenceTestModel;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class IndependenceTestModels {
    private static final IndependenceTestModels INSTANCE = new IndependenceTestModels();
    private final List<IndependenceTestModel> models;
    private final Map<DataType, List<IndependenceTestModel>> modelMap = new EnumMap<DataType, List<IndependenceTestModel>>(DataType.class);
    private final Map<DataType, IndependenceTestModel> defaultModelMap = new EnumMap<DataType, IndependenceTestModel>(DataType.class);

    private IndependenceTestModels() {
        TestOfIndependenceAnnotations indTestAnno = TestOfIndependenceAnnotations.getInstance();
        List list = Tetrad.enableExperimental ? indTestAnno.getAnnotatedClasses() : indTestAnno.filterOutExperimental(indTestAnno.getAnnotatedClasses());
        this.models = Collections.unmodifiableList(list.stream().map(IndependenceTestModel::new).sorted().collect(Collectors.toList()));
        this.initModelMap();
        this.initDefaultModelMap();
    }

    private void initModelMap() {
        DataType[] dataTypes;
        for (DataType dataType : dataTypes = DataType.values()) {
            this.modelMap.put(dataType, new LinkedList());
        }
        this.models.forEach(e -> {
            DataType[] types;
            for (DataType dataType : types = e.getIndependenceTest().getAnnotation().dataType()) {
                this.modelMap.get((Object)dataType).add((IndependenceTestModel)e);
            }
        });
        List mergedModels = Stream.concat(this.modelMap.get((Object)DataType.Continuous).stream(), this.modelMap.get((Object)DataType.Mixed).stream()).sorted().collect(Collectors.toList());
        this.modelMap.put(DataType.Continuous, mergedModels);
        mergedModels = Stream.concat(this.modelMap.get((Object)DataType.Discrete).stream(), this.modelMap.get((Object)DataType.Mixed).stream()).sorted().collect(Collectors.toList());
        this.modelMap.put(DataType.Discrete, mergedModels);
        this.modelMap.forEach((k, v) -> this.modelMap.put((DataType)((Object)k), Collections.unmodifiableList(v)));
    }

    private void initDefaultModelMap() {
        DataType[] dataTypes;
        for (DataType dataType : dataTypes = DataType.values()) {
            List<IndependenceTestModel> list = this.getModels(dataType);
            if (list.isEmpty()) continue;
            String property = this.getProperty(dataType);
            if (property == null) {
                this.defaultModelMap.put(dataType, list.get(0));
                continue;
            }
            String value = TetradProperties.getInstance().getValue(property);
            if (value == null) {
                this.defaultModelMap.put(dataType, list.get(0));
                continue;
            }
            Optional<IndependenceTestModel> result = list.stream().filter(e -> e.getIndependenceTest().getClazz().getName().equals(value)).findFirst();
            this.defaultModelMap.put(dataType, result.orElseGet(() -> (IndependenceTestModel)list.get(0)));
        }
    }

    private String getProperty(DataType dataType) {
        switch (dataType) {
            case Continuous: {
                return "datatype.continuous.test.default";
            }
            case Discrete: {
                return "datatype.discrete.test.default";
            }
            case Mixed: {
                return "datatype.mixed.test.default";
            }
        }
        return null;
    }

    public static IndependenceTestModels getInstance() {
        return INSTANCE;
    }

    public List<IndependenceTestModel> getModels() {
        return this.models;
    }

    public List<IndependenceTestModel> getModels(DataType dataType) {
        return this.modelMap.getOrDefault((Object)dataType, Collections.EMPTY_LIST);
    }

    public IndependenceTestModel getDefaultModel(DataType dataType) {
        return this.defaultModelMap.get((Object)dataType);
    }
}

