/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.ui.model;

import edu.cmu.tetrad.annotation.AnnotatedClass;
import edu.cmu.tetrad.annotation.Score;
import edu.cmu.tetrad.util.ScoreDescriptions;
import java.io.Serializable;

public class ScoreModel
implements Serializable,
Comparable<ScoreModel> {
    private static final long serialVersionUID = 2755370016466432455L;
    private final AnnotatedClass<Score> score;
    private final String name;
    private final String description;

    public ScoreModel(AnnotatedClass<Score> score) {
        this.score = score;
        this.name = score.getAnnotation().name();
        this.description = ScoreDescriptions.getInstance().get(score.getAnnotation().command());
    }

    @Override
    public int compareTo(ScoreModel other) {
        return this.score.getAnnotation().name().compareTo(other.score.getAnnotation().name());
    }

    public String toString() {
        return this.name;
    }

    public AnnotatedClass<Score> getScore() {
        return this.score;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

