/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.ui.model;

import edu.cmu.tetrad.annotation.ScoreAnnotations;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.util.TetradProperties;
import edu.cmu.tetradapp.Tetrad;
import edu.cmu.tetradapp.ui.model.ScoreModel;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ScoreModels {
    private static final ScoreModels INSTANCE = new ScoreModels();
    private final List<ScoreModel> models;
    private final Map<DataType, List<ScoreModel>> modelMap = new EnumMap<DataType, List<ScoreModel>>(DataType.class);
    private final Map<DataType, ScoreModel> defaultModelMap = new EnumMap<DataType, ScoreModel>(DataType.class);

    private ScoreModels() {
        ScoreAnnotations scoreAnno = ScoreAnnotations.getInstance();
        List list = Tetrad.enableExperimental ? scoreAnno.getAnnotatedClasses() : scoreAnno.filterOutExperimental(scoreAnno.getAnnotatedClasses());
        this.models = Collections.unmodifiableList(list.stream().map(ScoreModel::new).sorted().collect(Collectors.toList()));
        this.initModelMap();
        this.initDefaultModelMap();
    }

    private void initModelMap() {
        DataType[] dataTypes;
        for (DataType dataType : dataTypes = DataType.values()) {
            this.modelMap.put(dataType, new LinkedList());
        }
        this.models.forEach(e -> {
            DataType[] types;
            for (DataType dataType : types = e.getScore().getAnnotation().dataType()) {
                this.modelMap.get((Object)dataType).add((ScoreModel)e);
            }
        });
        List mergedModels = Stream.concat(this.modelMap.get((Object)DataType.Continuous).stream(), this.modelMap.get((Object)DataType.Mixed).stream()).sorted().collect(Collectors.toList());
        this.modelMap.put(DataType.Continuous, mergedModels);
        mergedModels = Stream.concat(this.modelMap.get((Object)DataType.Discrete).stream(), this.modelMap.get((Object)DataType.Mixed).stream()).sorted().collect(Collectors.toList());
        this.modelMap.put(DataType.Discrete, mergedModels);
        this.modelMap.forEach((k, v) -> this.modelMap.put((DataType)((Object)k), Collections.unmodifiableList(v)));
    }

    private void initDefaultModelMap() {
        DataType[] dataTypes;
        for (DataType dataType : dataTypes = DataType.values()) {
            List<ScoreModel> list = this.getModels(dataType);
            if (list.isEmpty()) continue;
            String property = this.getProperty(dataType);
            if (property == null) {
                this.defaultModelMap.put(dataType, list.get(0));
                continue;
            }
            String value = TetradProperties.getInstance().getValue(property);
            if (value == null) {
                this.defaultModelMap.put(dataType, list.get(0));
                continue;
            }
            Optional<ScoreModel> result = list.stream().filter(e -> e.getScore().getClazz().getName().equals(value)).findFirst();
            this.defaultModelMap.put(dataType, result.orElseGet(() -> (ScoreModel)list.get(0)));
        }
    }

    private String getProperty(DataType dataType) {
        switch (dataType) {
            case Continuous: {
                return "datatype.continuous.score.default";
            }
            case Discrete: {
                return "datatype.discrete.score.default";
            }
            case Mixed: {
                return "datatype.mixed.score.default";
            }
        }
        return null;
    }

    public static ScoreModels getInstance() {
        return INSTANCE;
    }

    public List<ScoreModel> getModels() {
        return this.models;
    }

    public List<ScoreModel> getModels(DataType dataType) {
        return this.modelMap.getOrDefault((Object)dataType, Collections.EMPTY_LIST);
    }

    public ScoreModel getDefaultModel(DataType dataType) {
        return this.defaultModelMap.get((Object)dataType);
    }
}

