/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.ui.tool;

import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Version;
import edu.cmu.tetradapp.app.DecompressibleInputStream;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;

public class SessionFileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -6674597813640455425L;

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        for (DataFlavor flavor : support.getDataFlavors()) {
            if (!flavor.isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        try {
            List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                Preferences.userRoot().put("sessionSaveLocation", file.getParent());
                Session session = DesktopController.getInstance().getSessionByName(file.getName());
                if (session != null) {
                    if (session.isEmpty()) {
                        DesktopController.getInstance().closeSessionByName(file.getName());
                    } else {
                        int ret = JOptionPane.showConfirmDialog(JOptionUtils.centeringComp(), "Replace existing session by that name?.", "Confirm", 0);
                        if (ret != 0) return false;
                        DesktopController.getInstance().closeSessionByName(file.getName());
                    }
                }
                try {
                    InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    try {
                        DecompressibleInputStream objIn = new DecompressibleInputStream(in);
                        Object o = objIn.readObject();
                        TetradMetadata metadata = null;
                        SessionWrapper sessionWrapper = null;
                        if (o instanceof TetradMetadata) {
                            metadata = (TetradMetadata)o;
                            try {
                                sessionWrapper = (SessionWrapper)objIn.readObject();
                            }
                            catch (ClassNotFoundException e1) {
                                throw e1;
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        } else if (o instanceof SessionWrapper) {
                            sessionWrapper = (SessionWrapper)o;
                        }
                        in.close();
                        if (metadata == null) {
                            throw new NullPointerException("Could not read metadata.");
                        }
                        if (sessionWrapper == null) {
                            Version version = metadata.getVersion();
                            Date date = metadata.getDate();
                            SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy");
                            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Could not load this session file into Tetrad " + Version.currentViewableVersion() + "! \nThe session was saved by Tetrad " + version + " on " + df.format(date));
                            boolean bl = false;
                            return bl;
                        }
                        SessionEditorWorkbench graph = new SessionEditorWorkbench(sessionWrapper);
                        String name = file.getName();
                        sessionWrapper.setName(name);
                        SessionEditor editor = new SessionEditor(name, graph);
                        DesktopController.getInstance().addSessionEditor(editor);
                        DesktopController.getInstance().closeEmptySessions();
                        DesktopController.getInstance().putMetadata(sessionWrapper, metadata);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (FileNotFoundException exception) {
                    TetradLogger.getInstance().forceLogMessage(exception.toString());
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "That wasn't a TETRAD session file: " + file);
                }
                catch (Exception exception) {
                    TetradLogger.getInstance().forceLogMessage(exception.toString());
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "An error occurred attempting to load the session.");
                }
            }
            return super.importData(support);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            TetradLogger.getInstance().forceLogMessage(exception.toString());
        }
        return super.importData(support);
    }
}

