/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import javax.swing.JTextField;
import org.apache.commons.math3.util.FastMath;

public class DoubleTextField
extends JTextField {
    private double value;
    private NumberFormat format;
    private NumberFormat smallNumberFormat;
    private double smallNumberCutoff = 1.0E-4;
    private Filter filter;

    public DoubleTextField(double value, int width, NumberFormat format) {
        super(width);
        this.setup(value, format, format, 1.0E-4);
    }

    public DoubleTextField(double value, int width, NumberFormat format, NumberFormat smallNumberFormat, double smallNumberCutoff) {
        super(width);
        this.setup(value, format, smallNumberFormat, smallNumberCutoff);
    }

    public void setValue(double value) {
        if (value == this.value) {
            return;
        }
        double newValue = this.filter(value, this.value);
        if (newValue == this.value) {
            this.smartSetText(this.format, this.value);
        } else {
            this.value = newValue;
            this.smartSetText(this.format, this.value);
            this.firePropertyChange("newValue", null, (Object)this.value);
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private double filter(double value, double oldValue) {
        if (this.filter == null) {
            return value;
        }
        return this.filter.filter(value, oldValue);
    }

    private void setup(double value, NumberFormat nf, NumberFormat smallNumberFormat, double smallNumberCutoff) {
        if (nf == null) {
            throw new NullPointerException();
        }
        this.value = this.filter(value, 0.0);
        this.format = nf;
        this.smallNumberFormat = smallNumberFormat;
        this.smallNumberCutoff = smallNumberCutoff;
        this.smartSetText(nf, this.value);
        this.addActionListener(e -> {
            try {
                double value1 = Double.parseDouble(e.getActionCommand());
                this.setValue(value1);
            }
            catch (NumberFormatException e1) {
                this.setText(this.format.format(this.getValue()));
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DoubleTextField source = (DoubleTextField)e.getSource();
                if (source.isEditable()) {
                    source.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    double value = Double.parseDouble(DoubleTextField.this.getText());
                    DoubleTextField.this.setValue(value);
                }
                catch (NumberFormatException e1) {
                    if ("".equals(DoubleTextField.this.getText().trim())) {
                        DoubleTextField.this.setValue(Double.NaN);
                    }
                    DoubleTextField.this.setValue(DoubleTextField.this.getValue());
                }
            }
        });
    }

    private void smartSetText(NumberFormat nf, double value) {
        if (Double.isNaN(value)) {
            this.setHorizontalAlignment(4);
            this.setText("");
        } else {
            this.setHorizontalAlignment(4);
            if (FastMath.abs(value) < this.smallNumberCutoff && value != 0.0) {
                this.setText(this.smallNumberFormat.format(value));
            } else {
                this.setText(nf.format(value));
            }
        }
    }

    public static interface Filter {
        public double filter(double var1, double var3);
    }
}

