/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class FileLoadingUtils {
    public static String fromFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
        String s = cbuf.toString();
        fis.close();
        return s;
    }

    public static String fromResources(String path) {
        try {
            String line;
            URL url = Version.class.getResource(path);
            if (url == null) {
                throw new RuntimeException("Could not load resource file: " + path);
            }
            InputStream inStream = url.openStream();
            InputStreamReader reader = new InputStreamReader(inStream);
            BufferedReader bufReader = new BufferedReader(reader);
            StringBuilder spec = new StringBuilder();
            while ((line = bufReader.readLine()) != null) {
                spec.append(line).append("\n");
            }
            bufReader.close();
            return spec.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Could not load resource file: " + path);
        }
    }
}

