/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetradapp.util.IntTextField;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class IntSpinner
extends JSpinner {
    private final IntTextField editor;
    private Filter filter;
    private Integer min;
    private Integer max;

    public IntSpinner(Integer value, Integer step, Integer size) {
        super(new SpinnerNumberModel(value, null, null, step));
        this.editor = new IntTextField(value, (int)size);
        this.setPreferredSize(IntSpinner.increment(this.editor.getPreferredSize()));
        this.setMaximumSize(IntSpinner.increment(this.editor.getMaximumSize()));
        this.setMinimumSize(IntSpinner.increment(this.editor.getMinimumSize()));
        this.setSize(IntSpinner.increment(this.editor.getSize()));
        this.editor.setFilter((int value1, int oldValue) -> {
            if (this.min != null && value1 < this.min) {
                value1 = this.min;
            } else if (this.max != null && this.max < value1) {
                value1 = this.max;
            }
            return value1;
        });
        this.editor.addActionListener(e -> {
            IntTextField field = (IntTextField)e.getSource();
            String text = field.getText();
            try {
                int value12 = Integer.parseInt(text);
                field.setValue(value12);
                value12 = field.getValue();
                if (!this.getValue().equals(value12)) {
                    this.setValue(value12);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.setEditor(this.editor);
    }

    public void setMin(Integer min) {
        if (!Objects.equals(this.min, min)) {
            this.min = min;
            SpinnerNumberModel model = (SpinnerNumberModel)this.getModel();
            model.setMinimum(min);
            this.editor.setValue(this.editor.getValue());
        }
    }

    public void setMax(Integer max) {
        if (!Objects.equals(this.max, max)) {
            this.max = max;
            SpinnerNumberModel model = (SpinnerNumberModel)this.getModel();
            model.setMaximum(max);
            this.editor.setValue(this.editor.getValue());
        }
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int value = this.filter((Integer)object);
        if (!this.getValue().equals(value)) {
            super.setValue(value);
            this.editor.setUnfilteredValue(value);
        }
    }

    private static Dimension increment(Dimension dim) {
        return new Dimension(dim.width + 2, dim.height + 2);
    }

    private int filter(int value) {
        if (this.filter == null) {
            return value;
        }
        if (this.getValue().equals(value)) {
            return value;
        }
        return this.filter.filter((Integer)this.getValue(), value);
    }

    public static interface Filter {
        public int filter(int var1, int var2);
    }
}

