/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class LoggingMenu
extends JMenu {
    private final TetradLoggerConfig config;
    private Component parent;

    private LoggingMenu(TetradLoggerConfig config) {
        super("Logging");
        if (config == null) {
            throw new NullPointerException("The given config must not be null");
        }
        this.config = config;
        this.addMenuListener(new LoggingMenuListener());
    }

    public LoggingMenu(TetradLoggerConfig config, Component parent) {
        this(config);
        this.parent = parent;
    }

    private void buildMenu() {
        this.removeAll();
        JMenuItem setup = new JMenuItem("Setup Log Events...");
        setup.addActionListener(e -> this.showLogSetupDialog());
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Logging");
        menuItem.setSelected(TetradLogger.getInstance().isLogging());
        this.add(setup);
        this.addSeparator();
        this.add(menuItem);
        menuItem.addActionListener(e -> {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            TetradLogger.getInstance().setLogging(item.isSelected());
        });
    }

    private void showLogSetupDialog() {
        JPanel panel = new JPanel();
        List<TetradLoggerConfig.Event> events = this.config.getSupportedEvents();
        panel.setLayout(new GridLayout(3, events.size() / 3));
        for (TetradLoggerConfig.Event event : events) {
            String id = event.getId();
            JCheckBox checkBox = new JCheckBox(event.getDescription());
            checkBox.setHorizontalTextPosition(4);
            checkBox.setSelected(this.config.isEventActive(id));
            checkBox.addActionListener(e -> {
                JCheckBox box = (JCheckBox)e.getSource();
                this.config.setEventActive(id, box.isSelected());
            });
            panel.add(checkBox);
        }
        panel.setBorder(new TitledBorder("Select Events to Log"));
        Component comp = this.parent == null ? JOptionUtils.centeringComp() : this.parent;
        JOptionPane.showMessageDialog(comp, panel, "Logging Setup", -1);
    }

    private class LoggingMenuListener
    implements MenuListener {
        private LoggingMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            LoggingMenu.this.buildMenu();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

