/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;

public final class LongTextField
extends JTextField {
    private long value;
    private Filter filter;

    public LongTextField(long value, int size) {
        super(size);
        this.setValue(value);
        this.setText(Long.toString(value));
        this.setHorizontalAlignment(4);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long n = Long.parseLong(e.getActionCommand());
                    LongTextField.this.setValue(n);
                }
                catch (NumberFormatException e1) {
                    LongTextField.this.setText(Long.toString(LongTextField.this.getValue()));
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LongTextField source = (LongTextField)e.getSource();
                source.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    long n = Long.parseLong(LongTextField.this.getText());
                    LongTextField.this.setValue(n);
                }
                catch (NumberFormatException e1) {
                    LongTextField.this.setText(Long.toString(LongTextField.this.getValue()));
                }
            }
        });
    }

    public void setUnfilteredValue(long value) {
        this.setText(String.valueOf(value));
    }

    public void setValue(long value) {
        if (value == this.value) {
            return;
        }
        long newValue = this.filter(value, this.value);
        if (newValue == this.value) {
            this.setText(Long.toString(this.value));
        } else {
            this.value = newValue;
            this.setText(Long.toString(this.value));
            this.firePropertyChange("newValue", null, (Object)this.value);
        }
    }

    public long getValue() {
        return this.value;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private long filter(long value, long oldValue) {
        if (this.filter == null) {
            return value;
        }
        return this.filter.filter(value, oldValue);
    }

    public static interface Filter {
        public long filter(long var1, long var3);
    }
}

