/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.ParamDescription;
import edu.cmu.tetrad.util.ParamDescriptions;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.util.DoubleTextField;
import edu.cmu.tetradapp.util.IntTextField;
import edu.cmu.tetradapp.util.LongTextField;
import edu.cmu.tetradapp.util.StringTextField;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public final class ParameterComponents {
    private ParameterComponents() {
    }

    public static Box[] toArray(Map<String, Box> parameterComponents) {
        ParamDescriptions paramDescs = ParamDescriptions.getInstance();
        LinkedList boolComps = new LinkedList();
        LinkedList otherComps = new LinkedList();
        parameterComponents.forEach((k, v) -> {
            if (paramDescs.get((String)k).getDefaultValue() instanceof Boolean) {
                boolComps.add(v);
            } else {
                otherComps.add(v);
            }
        });
        return (Box[])Stream.concat(otherComps.stream(), boolComps.stream()).toArray(Box[]::new);
    }

    public static Map<String, Box> createParameterComponents(Set<String> params, Parameters parameters) {
        ParamDescriptions paramDescs = ParamDescriptions.getInstance();
        return params.stream().collect(Collectors.toMap(Function.identity(), e -> ParameterComponents.createParameterComponent(e, parameters, paramDescs.get((String)e)), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s.", u));
        }, TreeMap::new));
    }

    public static DoubleTextField getDoubleField(String parameter, Parameters parameters, double defaultValue, double lowerBound, double upperBound) {
        DoubleTextField field = new DoubleTextField(parameters.getDouble(parameter, defaultValue), 8, new DecimalFormat("0.####"), new DecimalFormat("0.0#E0"), 0.001);
        field.setFilter((value, oldValue) -> {
            if (value == field.getValue()) {
                return oldValue;
            }
            if (value < lowerBound) {
                return oldValue;
            }
            if (value > upperBound) {
                return oldValue;
            }
            try {
                parameters.set(parameter, (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }

    public static IntTextField getIntTextField(String parameter, Parameters parameters, int defaultValue, double lowerBound, double upperBound) {
        IntTextField field = new IntTextField(parameters.getInt(parameter, defaultValue), 8);
        field.setFilter((value, oldValue) -> {
            if (value == field.getValue()) {
                return oldValue;
            }
            if ((double)value < lowerBound) {
                return oldValue;
            }
            if ((double)value > upperBound) {
                return oldValue;
            }
            try {
                parameters.set(parameter, (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }

    public static LongTextField getLongTextField(String parameter, Parameters parameters, long defaultValue, double lowerBound, double upperBound) {
        LongTextField field = new LongTextField(parameters.getLong(parameter, defaultValue), 10);
        field.setFilter((value, oldValue) -> {
            if (value == field.getValue()) {
                return oldValue;
            }
            if ((double)value < lowerBound) {
                return oldValue;
            }
            if ((double)value > upperBound) {
                return oldValue;
            }
            try {
                parameters.set(parameter, (Object)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }

    public static Box getBooleanSelectionBox(String parameter, Parameters parameters, boolean defaultValue) {
        Box selectionBox = Box.createHorizontalBox();
        JRadioButton yesButton = new JRadioButton("Yes");
        JRadioButton noButton = new JRadioButton("No");
        ButtonGroup selectionBtnGrp = new ButtonGroup();
        selectionBtnGrp.add(yesButton);
        selectionBtnGrp.add(noButton);
        boolean aBoolean = parameters.getBoolean(parameter, defaultValue);
        if (aBoolean) {
            yesButton.setSelected(true);
        } else {
            noButton.setSelected(true);
        }
        selectionBox.add(yesButton);
        selectionBox.add(noButton);
        yesButton.addActionListener(e -> {
            JRadioButton button = (JRadioButton)e.getSource();
            if (button.isSelected()) {
                parameters.set(parameter, (Object)true);
            }
        });
        noButton.addActionListener(e -> {
            JRadioButton button = (JRadioButton)e.getSource();
            if (button.isSelected()) {
                parameters.set(parameter, (Object)false);
            }
        });
        return selectionBox;
    }

    public static StringTextField getStringField(String parameter, Parameters parameters, String defaultValue) {
        StringTextField field = new StringTextField(parameters.getString(parameter, defaultValue), 20);
        field.setFilter((value, oldValue) -> {
            if (value.equals(field.getValue().trim())) {
                return oldValue;
            }
            try {
                parameters.set(parameter, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        });
        return field;
    }

    private static Box createParameterComponent(String parameter, Parameters parameters, ParamDescription paramDesc) {
        int upperBoundInt;
        JComponent component;
        Serializable defaultValue = paramDesc.getDefaultValue();
        if (defaultValue instanceof Double) {
            double lowerBoundDouble = paramDesc.getLowerBoundDouble();
            double upperBoundDouble = paramDesc.getUpperBoundDouble();
            component = ParameterComponents.getDoubleField(parameter, parameters, (Double)defaultValue, lowerBoundDouble, upperBoundDouble);
        } else if (defaultValue instanceof Integer) {
            int lowerBoundInt = paramDesc.getLowerBoundInt();
            upperBoundInt = paramDesc.getUpperBoundInt();
            component = ParameterComponents.getIntTextField(parameter, parameters, (Integer)defaultValue, lowerBoundInt, upperBoundInt);
        } else if (defaultValue instanceof Long) {
            int lowerBoundInt = paramDesc.getLowerBoundInt();
            upperBoundInt = paramDesc.getUpperBoundInt();
            component = ParameterComponents.getLongTextField(parameter, parameters, (Long)defaultValue, lowerBoundInt, upperBoundInt);
        } else if (defaultValue instanceof Boolean) {
            component = ParameterComponents.getBooleanSelectionBox(parameter, parameters, (Boolean)defaultValue);
        } else if (defaultValue instanceof String) {
            component = ParameterComponents.getStringField(parameter, parameters, (String)((Object)defaultValue));
        } else {
            throw new IllegalArgumentException("Unexpected type: " + defaultValue.getClass());
        }
        Box paramRow = Box.createHorizontalBox();
        JLabel paramLabel = new JLabel(paramDesc.getShortDescription());
        String longDescription = paramDesc.getLongDescription();
        if (longDescription != null) {
            paramLabel.setToolTipText(longDescription);
        }
        paramRow.add(paramLabel);
        paramRow.add(Box.createHorizontalGlue());
        paramRow.add(component);
        return paramRow;
    }
}

