/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetradapp.util.LicenseUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class SplashScreen {
    private static int MAX;
    private static SplashWindow WINDOW;
    private static JFrame frame;

    public static void show(Frame parent, String title, int max) {
        SplashScreen.hide();
        MAX = max;
        WINDOW = new SplashWindow(parent, null, title);
    }

    public static void show(String title, int max) {
        SplashScreen.hide();
        MAX = max;
        frame = new JFrame();
        WINDOW = new SplashWindow(frame, null, title);
    }

    public static void hide() {
        if (WINDOW == null) {
            return;
        }
        SplashScreen.WINDOW.bar.setValue(MAX);
        SplashScreen.WINDOW.bar.repaint();
        WINDOW.setVisible(false);
        WINDOW.dispose();
        WINDOW = null;
        if (frame != null) {
            frame.dispose();
            frame = null;
        }
    }

    private static class SplashWindow
    extends Window {
        private static final long serialVersionUID = 6618487747518635416L;
        final Image splashIm;
        final JProgressBar bar;

        SplashWindow(Frame parent, Image image, String title) {
            super(parent);
            this.splashIm = image;
            JPanel panel = new JPanel();
            panel.setBackground(Color.white);
            panel.setBorder(BorderFactory.createLineBorder(Color.black));
            panel.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            Box b = Box.createVerticalBox();
            panel.add((Component)b, "Center");
            Box b1 = Box.createHorizontalBox();
            JLabel label = new JLabel(title, 0);
            label.setFont(label.getFont().deriveFont(16.0f));
            b1.add(Box.createHorizontalGlue());
            b1.add(label);
            b1.add(Box.createHorizontalGlue());
            b.add(b1);
            String text = LicenseUtils.copyright();
            JTextArea textArea = new JTextArea(text);
            textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
            b.add(textArea);
            this.bar = new JProgressBar(0, MAX);
            this.bar.setBackground(Color.white);
            this.bar.setBorderPainted(false);
            b.add(this.bar);
            this.pack();
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle bounds = this.getBounds();
            this.setLocation((screenDim.width - bounds.width) / 2, (screenDim.height - bounds.height) / 2);
            this.setVisible(true);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.splashIm != null) {
                g.drawImage(this.splashIm, 0, 0, this);
            }
        }
    }
}

