/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.TetradLogger;
import java.io.OutputStream;
import javax.swing.JTextArea;

public class TextAreaOutputStream
extends OutputStream
implements TetradLogger.LogDisplayOutputStream {
    private final JTextArea textArea;
    private final StringBuilder buf = new StringBuilder();
    private int lengthWritten;

    public TextAreaOutputStream(JTextArea textArea) {
        this.textArea = textArea;
        this.lengthWritten = textArea.getText().length();
    }

    @Override
    public synchronized void write(int b) {
        if (this.buf.length() > 5000) {
            return;
        }
        this.buf.append((char)b);
        if ((char)b == '\n') {
            this.textArea.append(this.buf.toString());
            this.lengthWritten += this.buf.length();
            this.buf.setLength(0);
            this.moveToEnd();
        }
    }

    public String toString() {
        return this.textArea.toString();
    }

    public void reset() {
        this.textArea.setText("");
        this.lengthWritten = 0;
    }

    @Override
    public int getLengthWritten() {
        return this.lengthWritten;
    }

    @Override
    public void moveToEnd() {
        this.textArea.setCaretPosition(0);
    }
}

