/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.util;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TaskManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public abstract class WatchedProcess {
    private Thread thread;
    private String errorMessage;
    private final long delay = 200L;
    private JDialog stopDialog;
    private final Window owner;
    private static final boolean SHOW_DIALOG = true;
    private final Component centeringComp;

    public WatchedProcess(Window owner) {
        this(owner, JOptionUtils.centeringComp());
    }

    private WatchedProcess(Window owner, Component centeringComp) {
        if (owner == null) {
            throw new NullPointerException();
        }
        this.owner = owner;
        this.centeringComp = centeringComp;
        this.watchProcess();
    }

    public abstract void watch();

    private String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private JDialog getStopDialog() {
        return this.stopDialog;
    }

    private void setStopDialog(JDialog stopDialog) {
        this.stopDialog = stopDialog;
    }

    private Window getOwner() {
        return this.owner;
    }

    private boolean isShowDialog() {
        return true;
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    private void watchProcess() {
        Runnable runnable = () -> {
            try {
                this.watch();
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = e.getMessage();
                if (e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                this.setErrorMessage(message);
                throw e;
            }
        };
        Thread thread = new Thread(runnable);
        this.setThread(thread);
        thread.setPriority(7);
        thread.start();
        if (this.isShowDialog()) {
            Thread watcher = new Thread(() -> {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e2) {
                    return;
                }
                if (this.getErrorMessage() != null) {
                    JOptionPane.showMessageDialog(this.centeringComp, this.getErrorMessage());
                    return;
                }
                JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setIndeterminate(true);
                JButton stopButton = new JButton("Stop");
                stopButton.addActionListener(e -> {
                    if (this.getThread() != null) {
                        while (this.getThread().isAlive()) {
                            TaskManager.getInstance().setCanceled(true);
                            this.getThread().stop();
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e1) {
                                JOptionPane.showMessageDialog(this.centeringComp, "Could not stop thread.");
                                return;
                            }
                        }
                    }
                });
                Box b = Box.createVerticalBox();
                Box b1 = Box.createHorizontalBox();
                b1.add(progressBar);
                b1.add(stopButton);
                b.add(b1);
                if (this.isShowDialog()) {
                    Frame ancestor = (Frame)JOptionUtils.centeringComp().getTopLevelAncestor();
                    JDialog dialog = new JDialog(ancestor, "Executing...", false);
                    this.setStopDialog(dialog);
                    dialog.getContentPane().add(b);
                    dialog.pack();
                    dialog.setLocationRelativeTo(this.centeringComp);
                    while (this.getThread().isAlive()) {
                        try {
                            Thread.sleep(200L);
                            if (this.existsOtherDialog()) {
                                dialog.setVisible(false);
                                continue;
                            }
                            dialog.setVisible(true);
                            dialog.toFront();
                        }
                        catch (InterruptedException e3) {
                            return;
                        }
                    }
                    dialog.setVisible(false);
                    dialog.dispose();
                    if (this.getErrorMessage() != null) {
                        JOptionPane.showMessageDialog(this.centeringComp, "Stopped with error:\n" + this.getErrorMessage());
                    }
                }
            });
            watcher.start();
        }
    }

    private Thread getThread() {
        return this.thread;
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }

    private boolean existsOtherDialog() {
        Window[] ownedWindows;
        Frame ancestor = (Frame)JOptionUtils.centeringComp().getTopLevelAncestor();
        for (Window window : ownedWindows = ancestor.getOwnedWindows()) {
            Dialog dialog;
            if (!(window instanceof Dialog) || window == this.getStopDialog() || window == this.getOwner() || !(dialog = (Dialog)window).isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isCanceled() {
        return false;
    }
}

