/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.util.PasteLayoutAction;
import edu.cmu.tetradapp.workbench.DisplayEdge;
import edu.cmu.tetradapp.workbench.DisplayLegend;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.GraphNodeError;
import edu.cmu.tetradapp.workbench.IDisplayEdge;
import edu.cmu.tetradapp.workbench.LayoutMenu;
import edu.cmu.tetradapp.workbench.PointPair;
import edu.cmu.tetradapp.workbench.Rubberband;
import edu.cmu.tetradapp.workbench.WorkbenchModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractWorkbench
extends JComponent
implements WorkbenchModel,
LayoutEditable {
    private static final long serialVersionUID = 6718395673225983249L;
    public static final int SELECT_MOVE = 0;
    public static final int ADD_NODE = 1;
    public static final int ADD_EDGE = 2;
    private Graph graph;
    private Map<Edge, Object> modelEdgesToDisplay;
    private Map<Node, Object> modelNodesToDisplay;
    private Map<Object, Object> displayToModel;
    private Map<Object, Object> displayToLabels;
    private int workbenchMode = 0;
    private IDisplayEdge trackedEdge;
    private Point clickPoint;
    private List<DisplayNode> dragNodes;
    private Rubberband rubberband;
    private boolean allowDoubleClickActions = true;
    private boolean allowNodeDragging = true;
    private boolean allowNodeEdgeSelection = true;
    private boolean allowEdgeReorientations = true;
    private final boolean allowMultipleSelection = true;
    private final ComponentHandler compHandler = new ComponentHandler(this);
    private final MouseHandler mouseHandler = new MouseHandler(this);
    private final MouseMotionHandler mouseMotionHandler = new MouseMotionHandler(this);
    private final PropertyChangeHandler propChangeHandler = new PropertyChangeHandler(this);
    private int maxX = 10000;
    private int maxY = 10000;
    private boolean nodeEdgeErrorsReported;
    private boolean rightClickPopupAllowed;
    private KeyEventDispatcher controlDispatcher;
    private Point currentMouseLocation;
    private boolean enableEditing = true;
    private boolean doPagColoring = false;

    protected AbstractWorkbench(Graph graph) {
        this.setGraph(graph);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseMotionHandler);
        this.setBackground(new Color(254, 254, 255));
        this.setFocusable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractWorkbench.this.grabFocus();
            }
        });
        this.setEnabled(this.enableEditing);
        new PasteLayoutAction(this).actionPerformed(null);
    }

    public final void deleteSelectedObjects() {
        Component[] components = this.getComponents();
        ArrayList<DisplayNode> graphNodes = new ArrayList<DisplayNode>();
        ArrayList<IDisplayEdge> graphEdges = new ArrayList<IDisplayEdge>();
        for (Component comp : components) {
            IDisplayEdge edge;
            if (comp instanceof DisplayNode) {
                DisplayNode node;
                if (!this.isDeleteVariablesAllowed() || !(node = (DisplayNode)comp).isSelected()) continue;
                graphNodes.add(node);
                continue;
            }
            if (!(comp instanceof IDisplayEdge) || !(edge = (IDisplayEdge)((Object)comp)).isSelected()) continue;
            graphEdges.add(edge);
        }
        for (DisplayNode graphNode : graphNodes) {
            this.removeNode(graphNode);
        }
        for (IDisplayEdge displayEdge : graphEdges) {
            try {
                this.removeEdge(displayEdge);
                this.resetEdgeOffsets(displayEdge);
            }
            catch (Exception e) {
                if (!this.isNodeEdgeErrorsReported()) continue;
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e.getMessage());
            }
        }
    }

    public final void deselectAll() {
        Component[] components;
        for (Component comp : components = this.getComponents()) {
            if (comp instanceof IDisplayEdge) {
                ((IDisplayEdge)((Object)comp)).setSelected(false);
                continue;
            }
            if (!(comp instanceof DisplayNode)) continue;
            ((DisplayNode)comp).setSelected(false);
        }
        this.repaint();
        this.firePropertyChange("BackgroundClicked", null, null);
    }

    public final int getWorkbenchMode() {
        return this.workbenchMode;
    }

    @Override
    public final Graph getGraph() {
        return this.graph;
    }

    public final List<DisplayNode> getSelectedNodes() {
        Component[] components;
        ArrayList<DisplayNode> selectedNodes = new ArrayList<DisplayNode>();
        for (Component comp : components = this.getComponents()) {
            if (!(comp instanceof DisplayNode) || !((DisplayNode)comp).isSelected()) continue;
            selectedNodes.add((DisplayNode)comp);
        }
        return selectedNodes;
    }

    public final DisplayNode getSelectedNode() {
        List<DisplayNode> selectedNodes = this.getSelectedNodes();
        if (selectedNodes.size() == 1) {
            return selectedNodes.get(0);
        }
        return null;
    }

    public final List<Component> getSelectedComponents() {
        Component[] components;
        ArrayList<Component> selectedComponents = new ArrayList<Component>();
        for (Component comp : components = this.getComponents()) {
            if (comp instanceof DisplayNode && ((DisplayNode)comp).isSelected()) {
                selectedComponents.add(comp);
                continue;
            }
            if (!(comp instanceof IDisplayEdge) || !((IDisplayEdge)((Object)comp)).isSelected()) continue;
            selectedComponents.add(comp);
        }
        return selectedComponents;
    }

    public final Edge getModelEdge(IDisplayEdge displayEdge) {
        return (Edge)this.getDisplayToModel().get(displayEdge);
    }

    private boolean isAllowMultipleNodeSelection() {
        return this.allowMultipleSelection;
    }

    private boolean isAllowDoubleClickActions() {
        return this.allowDoubleClickActions;
    }

    private boolean isAllowNodeDragging() {
        return this.allowNodeDragging;
    }

    private boolean isAllowNodeEdgeSelection() {
        return this.allowNodeEdgeSelection;
    }

    private boolean isAllowEdgeReorientation() {
        return this.allowEdgeReorientations;
    }

    public boolean isAllowMultipleSelection() {
        return this.allowMultipleSelection;
    }

    public final void setAllowDoubleClickActions(boolean allowDoubleClickActions) {
        if (this.isAllowDoubleClickActions() && !allowDoubleClickActions) {
            this.allowDoubleClickActions = false;
        } else if (!this.isAllowDoubleClickActions() && allowDoubleClickActions) {
            this.allowDoubleClickActions = true;
        }
    }

    public final void setAllowEdgeReorientations(boolean allowEdgeReorientations) {
        this.allowEdgeReorientations = allowEdgeReorientations;
    }

    public void setAllowNodeDragging(boolean allowNodeDragging) {
        this.allowNodeDragging = allowNodeDragging;
    }

    public void setAllowNodeEdgeSelection(boolean allowNodeEdgeSelection) {
        this.allowNodeEdgeSelection = allowNodeEdgeSelection;
    }

    public final void setGraph(Graph graph) {
        this.setGraphWithoutNotify(graph);
        this.scrollRectToVisible(this.getVisibleRect());
        this.registerKeys();
        this.firePropertyChange("graph", null, graph);
        this.firePropertyChange("modelChanged", null, null);
    }

    public final void setEdgeLabel(Edge modelEdge, JComponent label) {
        if (modelEdge == null) {
            throw new NullPointerException("Attempt to set a label on a null model edge: " + null);
        }
        if (!this.getModelEdgesToDisplay().containsKey(modelEdge)) {
            throw new IllegalArgumentException("Attempt to set a label on a model edge that's not in the editor: " + modelEdge);
        }
        DisplayEdge displayEdge = (DisplayEdge)this.getModelEdgesToDisplay().get(modelEdge);
        GraphEdgeLabel oldLabel = this.getEdgeLabel(displayEdge);
        if (oldLabel != null) {
            this.remove(oldLabel);
        }
        if (label != null) {
            GraphEdgeLabel edgeLabel = new GraphEdgeLabel(displayEdge, label);
            edgeLabel.setSize(edgeLabel.getPreferredSize());
            this.add((Component)edgeLabel, 0);
            this.setEdgeLabel(displayEdge, edgeLabel);
        }
        this.revalidate();
        this.repaint();
    }

    public final void setNodeToolTip(Node modelNode, String toolTipText) {
        if (modelNode == null) {
            throw new NullPointerException("Attempt to set a label on a null model node: " + null);
        }
        if (!this.getModelNodesToDisplay().containsKey(modelNode)) {
            throw new IllegalArgumentException("Attempt to set a label on a model node that's not in the editor: " + modelNode);
        }
        DisplayNode displayNode = (DisplayNode)this.getModelNodesToDisplay().get(modelNode);
        displayNode.setToolTipText(toolTipText);
    }

    public final void setEdgeToolTip(Edge modelEdge, String toolTipText) {
        if (modelEdge == null) {
            throw new NullPointerException("Attempt to set a label on a null model edge: " + null);
        }
        if (!this.getModelEdgesToDisplay().containsKey(modelEdge)) {
            throw new IllegalArgumentException("Attempt to set a label on a model edge that's not in the editor: " + modelEdge);
        }
        DisplayEdge displayEdge = (DisplayEdge)this.getModelEdgesToDisplay().get(modelEdge);
        displayEdge.setToolTipText(toolTipText);
    }

    public final void setNodeLabel(Node modelNode, JComponent label, int x, int y) {
        if (modelNode == null) {
            throw new NullPointerException("Attempt to set a label on a null model node.");
        }
        if (!this.getModelNodesToDisplay().containsKey(modelNode)) {
            return;
        }
        DisplayNode displayNode = (DisplayNode)this.getModelNodesToDisplay().get(modelNode);
        GraphNodeLabel oldLabel = this.getNodeLabel(displayNode);
        if (oldLabel != null) {
            this.remove(oldLabel);
        }
        if (label != null) {
            GraphNodeLabel nodeLabel = new GraphNodeLabel(displayNode, label, x, y);
            nodeLabel.setSize(nodeLabel.getPreferredSize());
            this.add((Component)nodeLabel, 0);
            this.setNodeLabel(displayNode, nodeLabel);
        }
        this.revalidate();
        this.repaint();
    }

    public final void setStrokeWidth(Edge edge, float width) {
        IDisplayEdge displayEdge = (IDisplayEdge)this.getModelEdgesToDisplay().get(edge);
        displayEdge.setStrokeWidth(width);
    }

    private void setEdgeLabel(IDisplayEdge displayEdge, GraphEdgeLabel edgeLabel) {
        this.getDisplayToLabels().put(displayEdge, edgeLabel);
    }

    private GraphEdgeLabel getEdgeLabel(IDisplayEdge displayEdge) {
        return (GraphEdgeLabel)this.getDisplayToLabels().get(displayEdge);
    }

    private void setNodeLabel(DisplayNode displayNode, GraphNodeLabel nodeLabel) {
        this.getDisplayToLabels().put(displayNode, nodeLabel);
    }

    private GraphNodeLabel getNodeLabel(DisplayNode displayNode) {
        return (GraphNodeLabel)this.getDisplayToLabels().get(displayNode);
    }

    private void removeEdgeLabel(Edge edge) {
        IDisplayEdge displayEdge = (IDisplayEdge)this.getModelEdgesToDisplay().get(edge);
        GraphEdgeLabel edgeLabel = this.getEdgeLabel(displayEdge);
        if (edgeLabel == null) {
            return;
        }
        this.remove(edgeLabel);
        this.getDisplayToLabels().remove(displayEdge);
    }

    public final void setWorkbenchMode(int workbenchMode) {
        if (workbenchMode == 0) {
            if (this.workbenchMode != 0) {
                this.workbenchMode = 0;
                this.setCursor(new Cursor(0));
                this.deselectAll();
            } else {
                this.setCursor(new Cursor(12));
            }
        } else if (workbenchMode == 1) {
            if (this.workbenchMode != 1) {
                this.workbenchMode = 1;
                this.deselectAll();
            }
        } else if (workbenchMode == 2) {
            if (this.workbenchMode != 2) {
                this.workbenchMode = 2;
                this.deselectAll();
            }
        } else {
            throw new IllegalArgumentException("Must be SELECT_MOVE, ADD_NODE, or ADD_EDGE.");
        }
    }

    @Override
    public final Map<Edge, Object> getModelEdgesToDisplay() {
        return this.modelEdgesToDisplay;
    }

    @Override
    public final Map<Node, Object> getModelNodesToDisplay() {
        return this.modelNodesToDisplay;
    }

    private Map<Object, Object> getDisplayToModel() {
        return this.displayToModel;
    }

    private void setMaxX(int maxX) {
        if (maxX < 100) {
            throw new IllegalArgumentException();
        }
        this.maxX = maxX;
    }

    public final void selectNode(Node modelNode) {
        if (!this.isAllowNodeEdgeSelection()) {
            return;
        }
        DisplayNode graphNode = (DisplayNode)this.getModelNodesToDisplay().get(modelNode);
        if (graphNode != null) {
            graphNode.setSelected(true);
        }
    }

    public final void selectEdge(Edge modelEdge) {
        IDisplayEdge graphEdge = (IDisplayEdge)this.getModelEdgesToDisplay().get(modelEdge);
        graphEdge.setSelected(true);
    }

    public final void selectConnectingEdges() {
        Component[] components;
        if (!this.isAllowNodeEdgeSelection()) {
            return;
        }
        for (Component comp : components = this.getComponents()) {
            if (!(comp instanceof IDisplayEdge)) continue;
            IDisplayEdge graphEdge = (IDisplayEdge)((Object)comp);
            DisplayNode node1 = graphEdge.getComp1();
            DisplayNode node2 = graphEdge.getComp2();
            if (node2 == null) continue;
            boolean selected = node1.isSelected() && node2.isSelected();
            graphEdge.setSelected(selected);
        }
    }

    private void selectConnectingEdges(List<DisplayNode> displayNodes) {
        Component[] components;
        if (!this.isAllowNodeEdgeSelection()) {
            return;
        }
        for (Component comp : components = this.getComponents()) {
            if (!(comp instanceof IDisplayEdge)) continue;
            IDisplayEdge graphEdge = (IDisplayEdge)((Object)comp);
            DisplayNode node1 = graphEdge.getComp1();
            DisplayNode node2 = graphEdge.getComp2();
            if (node1 instanceof GraphNodeError || node2 instanceof GraphNodeError || node2 == null) continue;
            boolean selected = displayNodes.contains(node1) && displayNodes.contains(node2);
            graphEdge.setSelected(selected);
        }
    }

    @Override
    public final void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    public final void scrollWorkbenchToNode(Node modelNode) {
        Object o = this.getModelNodesToDisplay().get(modelNode);
        DisplayNode displayNode = (DisplayNode)o;
        if (displayNode != null) {
            Rectangle bounds = displayNode.getBounds();
            this.scrollRectToVisible(bounds);
            this.deselectAll();
            if (this.isAllowNodeEdgeSelection()) {
                displayNode.setSelected(true);
            }
        }
    }

    private void setMaxY(int maxY) {
        if (maxY < 100) {
            throw new IllegalArgumentException();
        }
        this.maxY = maxY;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    @Override
    public Color getBackground() {
        return super.getBackground();
    }

    @Override
    public void layoutByGraph(Graph layoutGraph) {
        LayoutUtil.arrangeBySourceGraph(this.graph, layoutGraph);
        for (Node modelNode : this.graph.getNodes()) {
            DisplayNode displayNode = (DisplayNode)this.getModelNodesToDisplay().get(modelNode);
            if (displayNode == null) continue;
            Dimension dim = displayNode.getPreferredSize();
            int centerX = modelNode.getCenterX();
            int centerY = modelNode.getCenterY();
            displayNode.setSize(dim);
            displayNode.setLocation(centerX - dim.width / 2, centerY - dim.height / 2);
        }
    }

    @Override
    public Knowledge getKnowledge() {
        return null;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public void layoutByKnowledge() {
    }

    @Override
    public Rectangle getVisibleRect() {
        List<Node> nodes = this.graph.getNodes();
        if (nodes.isEmpty()) {
            return new Rectangle();
        }
        DisplayNode displayNode = (DisplayNode)this.getModelNodesToDisplay().get(nodes.get(0));
        Rectangle rect = displayNode.getBounds();
        for (int i = 1; i < nodes.size(); ++i) {
            displayNode = (DisplayNode)this.getModelNodesToDisplay().get(nodes.get(i));
            rect = rect.union(displayNode.getBounds());
        }
        rect = rect.union(super.getVisibleRect());
        return rect;
    }

    public void scrollNodesToVisible(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        DisplayNode displayNode = (DisplayNode)this.getModelNodesToDisplay().get(nodes.get(0));
        Rectangle rect = displayNode.getBounds();
        for (int i = 1; i < nodes.size(); ++i) {
            displayNode = (DisplayNode)this.getModelNodesToDisplay().get(nodes.get(i));
            rect = rect.union(displayNode.getBounds());
        }
        this.adjustPreferredSize();
        this.scrollRectToVisible(rect);
    }

    public Component getComponent(Edge edge) {
        return (DisplayEdge)this.modelEdgesToDisplay.get(edge);
    }

    public Component getComponent(Node node) {
        return (DisplayNode)this.modelNodesToDisplay.get(node);
    }

    @Override
    public abstract Node getNewModelNode();

    @Override
    public abstract DisplayNode getNewDisplayNode(Node var1);

    @Override
    public abstract IDisplayEdge getNewDisplayEdge(Edge var1);

    @Override
    public abstract Edge getNewModelEdge(Node var1, Node var2);

    @Override
    public abstract IDisplayEdge getNewTrackingEdge(DisplayNode var1, Point var2);

    private void setGraphWithoutNotify(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph model cannot be null.");
        }
        this.graph = graph;
        this.modelEdgesToDisplay = new HashMap<Edge, Object>();
        this.modelNodesToDisplay = new HashMap<Node, Object>();
        this.displayToModel = new HashMap<Object, Object>();
        this.displayToLabels = new HashMap<Object, Object>();
        this.removeAll();
        graph.addPropertyChangeListener(this.propChangeHandler);
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            if (this.getModelNodesToDisplay().containsKey(node)) continue;
            this.addNode(node);
        }
        Set<Edge> edges = graph.getEdges();
        for (Edge edge : edges) {
            if (this.getModelEdgesToDisplay().containsKey(edge)) continue;
            this.addEdge(edge);
        }
        this.adjustPreferredSize();
        if (this.getPreferredSize().getWidth() > (double)this.getMaxX()) {
            this.setMaxX((int)this.getPreferredSize().getWidth());
        }
        if (this.getPreferredSize().getHeight() > (double)this.getMaxY()) {
            this.setMaxY((int)this.getPreferredSize().getHeight());
        }
        if (graph.getAllAttributes().size() > 0) {
            int n = 5;
            DisplayLegend legend = new DisplayLegend(graph.getAllAttributes());
            legend.setLocation(5, 5);
            this.add((Component)legend, 0);
        }
        this.revalidate();
        this.repaint();
    }

    private int getMaxX() {
        return this.maxX;
    }

    private void adjustPreferredSize() {
        Component[] components = this.getComponents();
        Rectangle r = new Rectangle(0, 0, 400, 400);
        for (Component component1 : components) {
            r = r.union(component1.getBounds());
        }
        this.setPreferredSize(new Dimension(r.width, r.height));
        this.setSize(new Dimension(r.width, r.height));
    }

    private void addNode(Point loc) throws IllegalArgumentException {
        Node modelNode = this.getNewModelNode();
        if (modelNode.getNodeType() == NodeType.MEASURED && !this.isAddMeasuredVarsAllowed()) {
            throw new IllegalArgumentException("Attempt to add measured variable when this has been disallowed.");
        }
        modelNode.setCenterX(loc.x);
        modelNode.setCenterY(loc.y);
        this.getGraph().addNode(modelNode);
        this.firePropertyChange("modelChanged", null, null);
    }

    private void addNode(Node modelNode) {
        if (this.getModelNodesToDisplay().containsKey(modelNode)) {
            return;
        }
        if (modelNode.getNodeType() == NodeType.MEASURED && !this.isAddMeasuredVarsAllowed()) {
            throw new IllegalArgumentException("Attempt to add measured variable when this has been disallowed.");
        }
        int centerX = modelNode.getCenterX();
        int centerY = modelNode.getCenterY();
        DisplayNode displayNode = this.getNewDisplayNode(modelNode);
        this.getModelNodesToDisplay().put(modelNode, displayNode);
        this.getDisplayToModel().put(displayNode, modelNode);
        Dimension dim = displayNode.getPreferredSize();
        displayNode.setSize(dim);
        displayNode.setLocation(centerX - dim.width / 2, centerY - dim.height / 2);
        this.add((Component)displayNode, 0);
        this.snapNodeToGrid(displayNode);
        displayNode.addComponentListener(this.compHandler);
        displayNode.addMouseListener(this.mouseHandler);
        displayNode.addMouseMotionListener(this.mouseMotionHandler);
        displayNode.addPropertyChangeListener(this.propChangeHandler);
        this.adjustForNewModelNodes();
        this.repaint();
        this.validate();
        this.firePropertyChange("nodeAdded", null, displayNode);
        this.firePropertyChange("allNodesAdded", null, null);
    }

    private void adjustForNewModelNodes() {
        this.graph.getNodes().forEach(node -> {
            if (this.modelNodesToDisplay.get(node) == null) {
                int centerX = node.getCenterX();
                int centerY = node.getCenterY();
                DisplayNode displayNode = this.getNewDisplayNode((Node)node);
                this.modelNodesToDisplay.put((Node)node, displayNode);
                this.displayToModel.put(displayNode, node);
                Dimension dim = displayNode.getPreferredSize();
                displayNode.setSize(dim);
                displayNode.setLocation(centerX - dim.width / 2, centerY - dim.height / 2);
                this.add((Component)displayNode, 0);
                displayNode.addComponentListener(this.compHandler);
                displayNode.addMouseListener(this.mouseHandler);
                displayNode.addMouseMotionListener(this.mouseMotionHandler);
                displayNode.addPropertyChangeListener(this.propChangeHandler);
                this.firePropertyChange("nodeAdded", null, displayNode);
            }
        });
        HashMap<DisplayNode, Node> trashMap = new HashMap<DisplayNode, Node>();
        this.displayToModel.forEach((k, v) -> {
            if (k instanceof DisplayNode && v instanceof Node) {
                DisplayNode displayNode = (DisplayNode)k;
                Node node = (Node)v;
                if (!this.graph.containsNode(node)) {
                    trashMap.put(displayNode, node);
                }
            }
        });
        trashMap.forEach((k, v) -> {
            this.displayToModel.remove(k);
            this.modelNodesToDisplay.remove(v);
            this.firePropertyChange("nodeRemoved", null, k);
        });
        this.graph.getNodes().forEach(node -> {
            int centerX = node.getCenterX();
            int centerY = node.getCenterY();
            DisplayNode displayNode = (DisplayNode)this.modelNodesToDisplay.get(node);
            Dimension dim = displayNode.getPreferredSize();
            displayNode.setSize(dim);
            displayNode.setLocation(centerX - dim.width / 2, centerY - dim.height / 2);
        });
    }

    private void addEdge(Edge modelEdge) {
        if (modelEdge == null) {
            return;
        }
        if (modelEdge.getNode1() == modelEdge.getNode2()) {
            return;
        }
        if (this.getModelEdgesToDisplay().containsKey(modelEdge)) {
            return;
        }
        if (!this.getGraph().containsEdge(modelEdge)) {
            System.out.println("Attempt to add edge not in model: " + modelEdge);
            return;
        }
        Node modelNodeA = modelEdge.getNode1();
        Node modelNodeB = modelEdge.getNode2();
        DisplayNode displayNodeA = this.displayNode(modelNodeA);
        DisplayNode displayNodeB = this.displayNode(modelNodeB);
        if (displayNodeA == null || displayNodeB == null) {
            return;
        }
        IDisplayEdge displayEdge = this.getNewDisplayEdge(modelEdge);
        if (displayEdge == null) {
            return;
        }
        if (modelEdge.isHighlighted()) {
            displayEdge.setHighlighted(true);
        }
        if (this.doPagColoring) {
            boolean solid = modelEdge.getProperties().contains((Object)Edge.Property.nl);
            boolean thick = modelEdge.getProperties().contains((Object)Edge.Property.dd);
            displayEdge.setSolid(solid);
            displayEdge.setThick(thick);
        }
        this.getModelEdgesToDisplay().put(modelEdge, displayEdge);
        this.getDisplayToModel().put(displayEdge, modelEdge);
        this.add((Component)((Object)displayEdge), -1);
        ((Component)((Object)displayEdge)).addComponentListener(this.compHandler);
        ((Component)((Object)displayEdge)).addMouseListener(this.mouseHandler);
        ((Component)((Object)displayEdge)).addMouseMotionListener(this.mouseMotionHandler);
        ((Component)((Object)displayEdge)).addPropertyChangeListener(this.propChangeHandler);
        this.resetEdgeOffsets(displayEdge);
        this.firePropertyChange("edgeAdded", null, displayEdge);
    }

    private void resetEdgeOffsets(IDisplayEdge graphEdge) {
        try {
            DisplayNode displayNode1 = graphEdge.getNode1();
            DisplayNode displayNode2 = graphEdge.getNode2();
            Node node1 = displayNode1.getModelNode();
            Node node2 = displayNode2.getModelNode();
            Graph graph = this.getGraph();
            List<Edge> edges = graph.getEdges(node1, node2);
            for (int i = 0; i < edges.size(); ++i) {
                Edge edge = edges.get(i);
                Node _node1 = edge.getNode1();
                boolean awayFrom = _node1 == node1;
                IDisplayEdge displayEdge = (IDisplayEdge)this.getModelEdgesToDisplay().get(edge);
                if (displayEdge == null) continue;
                displayEdge.setOffset(AbstractWorkbench.calcEdgeOffset(i, edges.size(), awayFrom));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static double calcEdgeOffset(int i, int n, boolean away_from) {
        double offset = 35.0 * (2.0 * (double)i + 1.0 - (double)n) / 2.0 / (double)n;
        double direction = away_from ? 1.0 : -1.0;
        return direction * offset;
    }

    private DisplayNode displayNode(Node modelNodeA) {
        Object o = this.getModelNodesToDisplay().get(modelNodeA);
        if (o == null) {
            this.reconstiteMaps();
            o = this.getModelNodesToDisplay().get(modelNodeA);
        }
        return (DisplayNode)o;
    }

    private static double distance(Point p1, Point p2) {
        double d = (p1.x - p2.x) * (p1.x - p2.x);
        d += (double)((p1.y - p2.y) * (p1.y - p2.y));
        d = FastMath.sqrt(d);
        return d;
    }

    private DisplayNode findNearestNode(Point p) {
        Component[] components = this.getComponents();
        double leastDistance = Double.POSITIVE_INFINITY;
        int index = -1;
        for (int i = 0; i < components.length; ++i) {
            DisplayNode node;
            double distance;
            if (!(components[i] instanceof DisplayNode) || !((distance = AbstractWorkbench.distance(p, (node = (DisplayNode)components[i]).getCenterPoint())) < leastDistance)) continue;
            leastDistance = distance;
            index = i;
        }
        if (index != -1) {
            return (DisplayNode)components[index];
        }
        return null;
    }

    private void finishRubberband() {
        if (this.rubberband != null) {
            this.remove(this.rubberband);
            this.rubberband = null;
            this.repaint();
        }
    }

    private void finishEdge() {
        block4: {
            Point p;
            DisplayNode comp2;
            if (this.getTrackedEdge() == null) {
                return;
            }
            DisplayNode comp1 = this.getTrackedEdge().getComp1();
            if (comp1 != (comp2 = this.findNearestNode(p = this.getTrackedEdge().getTrackPoint()))) {
                try {
                    Node node1 = (Node)this.getDisplayToModel().get(comp1);
                    Node node2 = (Node)this.getDisplayToModel().get(comp2);
                    Edge modelEdge = this.getNewModelEdge(node1, node2);
                    this.graph.addEdge(modelEdge);
                    this.setGraph(this.graph);
                    this.firePropertyChange("modelChanged", null, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.isNodeEdgeErrorsReported()) break block4;
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e.getMessage());
                }
            }
        }
        this.remove((Component)((Object)this.getTrackedEdge()));
        this.repaint();
        this.trackedEdge = null;
    }

    private void fireNodeSelection() {
        Component[] components = this.getComponents();
        LinkedList<Node> selection = new LinkedList<Node>();
        for (Component component : components) {
            DisplayNode displayNode;
            if (!(component instanceof DisplayNode) || !(displayNode = (DisplayNode)component).isSelected()) continue;
            Node modelNode = (Node)this.getDisplayToModel().get(displayNode);
            selection.add(modelNode);
        }
        if (this.isAllowMultipleNodeSelection()) {
            this.firePropertyChange("selectedNodes", null, selection);
        } else if (selection.size() == 1) {
            this.firePropertyChange("selectedNode", null, selection.get(0));
        } else {
            throw new IllegalStateException("Multiple or null selection detected when single selection mode is set.");
        }
    }

    private void registerKeys() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(8, 0), "DELETE");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "DELETE");
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractWorkbench workbench = (AbstractWorkbench)e.getSource();
                List<Component> components = workbench.getSelectedComponents();
                int numNodes = 0;
                int numEdges = 0;
                for (Component c : components) {
                    if (c instanceof DisplayNode) {
                        ++numNodes;
                        continue;
                    }
                    if (!(c instanceof DisplayEdge)) continue;
                    ++numEdges;
                }
                StringBuilder buf = new StringBuilder();
                if (AbstractWorkbench.this.isDeleteVariablesAllowed()) {
                    buf.append("Number of nodes selected = ");
                    buf.append(numNodes);
                }
                buf.append("\nNumber of edges selected = ");
                buf.append(numEdges);
                buf.append("\n\nDelete selected items?");
                int ret = JOptionPane.showConfirmDialog(workbench, buf.toString());
                if (ret != 0) {
                    return;
                }
                AbstractWorkbench.this.deleteSelectedObjects();
            }
        };
        this.getActionMap().put("DELETE", deleteAction);
        if (this.controlDispatcher == null) {
            this.controlDispatcher = this::respondToControlKey;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.controlDispatcher);
    }

    private boolean respondToControlKey(KeyEvent e) {
        if (this.hasFocus()) {
            int keyCode = e.getKeyCode();
            int id = e.getID();
            if (keyCode == 18) {
                if (id == 401) {
                    this.workbenchMode = 2;
                    this.setCursor(new Cursor(1));
                } else if (id == 402) {
                    this.finishEdge();
                    this.workbenchMode = 0;
                    this.setCursor(new Cursor(0));
                }
            }
        }
        return false;
    }

    AbstractWorkbench getWorkbench() {
        return this;
    }

    private void removeNode(Node modelNode) {
        if (modelNode == null) {
            throw new NullPointerException("Attempt to remove a null model node.");
        }
        DisplayNode displayNode = (DisplayNode)this.getModelNodesToDisplay().get(modelNode);
        if (displayNode == null) {
            this.getModelNodesToDisplay().remove(modelNode);
        } else {
            this.setNodeLabel(modelNode, null, 0, 0);
            this.remove(displayNode);
            this.getDisplayToModel().remove(displayNode);
            this.getModelEdgesToDisplay().remove(modelNode);
            displayNode.removePropertyChangeListener(this.propChangeHandler);
            this.repaint();
            this.firePropertyChange("nodeRemoved", displayNode, null);
        }
    }

    private void removeNode(DisplayNode displayNode) {
        if (displayNode == null) {
            return;
        }
        Node modelNode = (Node)this.getDisplayToModel().get(displayNode);
        if (modelNode == null) {
            return;
        }
        if (modelNode.getNodeType() != NodeType.ERROR) {
            this.getGraph().removeNode(modelNode);
        }
        this.adjustForNewModelNodes();
        this.firePropertyChange("modelChanged", null, null);
    }

    private void removeEdge(Edge modelEdge) {
        if (modelEdge == null) {
            return;
        }
        IDisplayEdge displayEdge = (IDisplayEdge)this.getModelEdgesToDisplay().get(modelEdge);
        if (displayEdge == null) {
            this.getModelEdgesToDisplay().remove(modelEdge);
        } else {
            this.removeEdgeLabel(modelEdge);
            this.remove((Component)((Object)displayEdge));
            this.getDisplayToModel().remove(displayEdge);
            this.getModelEdgesToDisplay().remove(modelEdge);
            ((Component)((Object)displayEdge)).removePropertyChangeListener(this.propChangeHandler);
            this.repaint();
            this.firePropertyChange("edgeRemoved", displayEdge, null);
        }
    }

    private void removeEdge(IDisplayEdge displayEdge) {
        block3: {
            if (displayEdge == null) {
                return;
            }
            Edge modelEdge = (Edge)this.getDisplayToModel().get(displayEdge);
            try {
                this.getGraph().removeEdge(modelEdge);
                this.firePropertyChange("modelChanged", null, null);
            }
            catch (Exception e) {
                if (!this.isNodeEdgeErrorsReported()) break block3;
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e.getMessage());
            }
        }
    }

    private void selectAllInRubberband(Rubberband rubberband, boolean edgesOnly) {
        if (!this.isAllowNodeEdgeSelection()) {
            return;
        }
        if (!edgesOnly) {
            this.deselectAll();
        }
        Shape rubberShape = rubberband.getShape();
        Point rubberLoc = rubberband.getLocation();
        Component[] components = this.getComponents();
        ArrayList<DisplayNode> selectedNodes = new ArrayList<DisplayNode>();
        for (Component comp : components) {
            if (!(comp instanceof DisplayNode)) continue;
            Rectangle bounds = comp.getBounds();
            bounds.translate(-rubberLoc.x, -rubberLoc.y);
            DisplayNode graphNode = (DisplayNode)comp;
            if (!rubberShape.intersects(bounds)) continue;
            selectedNodes.add(graphNode);
        }
        if (edgesOnly) {
            this.selectConnectingEdges(selectedNodes);
        } else {
            for (DisplayNode graphNode : selectedNodes) {
                graphNode.setSelected(true);
            }
            this.selectConnectingEdges();
        }
    }

    private int getMaxY() {
        return this.maxY;
    }

    private void startEdge(DisplayNode node, Point mouseLoc) {
        if (this.getTrackedEdge() != null) {
            this.remove((Component)((Object)this.getTrackedEdge()));
            this.trackedEdge = null;
            this.repaint();
        }
        this.trackedEdge = this.getNewTrackingEdge(node, mouseLoc);
        this.add((Component)((Object)this.getTrackedEdge()), -1);
        this.deselectAll();
    }

    private void startNodeDrag(Point p) {
        if (!this.allowNodeDragging) {
            return;
        }
        this.clickPoint = p;
        this.dragNodes = this.getSelectedNodes();
    }

    private void startRubberband(Point p) {
        if (this.rubberband != null) {
            this.remove(this.rubberband);
            this.rubberband = null;
            this.repaint();
        }
        if (this.isAllowNodeEdgeSelection() && this.isAllowMultipleNodeSelection()) {
            this.rubberband = new Rubberband(p);
            this.add((Component)this.rubberband, 0);
            this.rubberband.repaint();
        }
    }

    private void snapNodeToGrid(DisplayNode node) {
        int gridSize = 20;
        int x = node.getCenterPoint().x;
        int y = node.getCenterPoint().y;
        x = 20 * ((x + 10) / 20);
        y = 20 * ((y + 10) / 20);
        node.setLocation(x - node.getSize().width / 2, y - node.getSize().height / 2);
    }

    private void handleMouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (!this.isAllowNodeEdgeSelection()) {
            return;
        }
        if (source instanceof DisplayNode) {
            this.nodeClicked(source, e);
        } else if (source instanceof IDisplayEdge) {
            this.edgeClicked(source, e);
        } else {
            if (e.isAltDown() && e.isControlDown() && e.isMetaDown()) {
                if (Preferences.userRoot().getBoolean("experimental", false)) {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Setting to published interface on next restart.");
                    Preferences.userRoot().putBoolean("experimental", false);
                } else {
                    JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Setting to experimental interface on next restart.");
                    Preferences.userRoot().putBoolean("experimental", true);
                }
            }
            this.deselectAll();
        }
    }

    private void edgeClicked(Object source, MouseEvent e) {
        IDisplayEdge graphEdge = (IDisplayEdge)source;
        if (e.getClickCount() == 2) {
            this.deselectAll();
            graphEdge.launchAssociatedEditor();
            this.firePropertyChange("edgeLaunch", graphEdge, graphEdge);
        } else {
            if (this.isAllowEdgeReorientation()) {
                this.reorientEdge(source, e);
            }
            if (graphEdge.isSelected()) {
                graphEdge.setSelected(false);
            } else if (e.isShiftDown()) {
                graphEdge.setSelected(true);
            } else {
                this.deselectAll();
                graphEdge.setSelected(true);
            }
        }
    }

    private void nodeClicked(Object source, MouseEvent e) {
        DisplayNode node = (DisplayNode)source;
        if (e.getClickCount() == 2) {
            if (this.isAllowDoubleClickActions()) {
                this.doDoubleClickAction(node);
            }
        } else {
            if (node.isSelected()) {
                node.setSelected(false);
            } else {
                if (!e.isShiftDown()) {
                    this.deselectAll();
                }
                node.setSelected(true);
            }
            this.selectConnectingEdges();
            this.fireNodeSelection();
        }
    }

    private void reorientEdge(Object source, MouseEvent e) {
        IDisplayEdge graphEdge = (IDisplayEdge)source;
        Point point = e.getPoint();
        PointPair connectedPoints = graphEdge.getConnectedPoints();
        Point pointA = connectedPoints.getFrom();
        Point pointB = connectedPoints.getTo();
        double length = AbstractWorkbench.distance(pointA, pointB);
        double endpointRadius = FastMath.min(20.0, length / 3.0);
        if (e.isShiftDown()) {
            if (AbstractWorkbench.distance(point, pointA) < endpointRadius) {
                this.toggleEndpoint(graphEdge, 1);
                this.fireModelChanged();
            } else if (AbstractWorkbench.distance(point, pointB) < endpointRadius) {
                this.toggleEndpoint(graphEdge, 2);
                this.firePropertyChange("modelChanged", null, null);
            }
        } else if (AbstractWorkbench.distance(point, pointA) < endpointRadius) {
            this.directEdge(graphEdge, 1);
            this.firePropertyChange("modelChanged", null, null);
        } else if (AbstractWorkbench.distance(point, pointB) < endpointRadius) {
            this.directEdge(graphEdge, 2);
            this.firePropertyChange("modelChanged", null, null);
        }
    }

    private void fireModelChanged() {
        this.firePropertyChange("modelChanged", null, null);
    }

    private void handleMousePressed(MouseEvent e) {
        this.grabFocus();
        Object source = e.getSource();
        Point loc = e.getPoint();
        if (this.isRightClickPopupAllowed() && source == this && SwingUtilities.isRightMouseButton(e)) {
            this.launchPopup(e);
            return;
        }
        switch (this.workbenchMode) {
            case 0: {
                if (source == this) {
                    this.startRubberband(loc);
                    break;
                }
                if (!(source instanceof DisplayNode)) break;
                this.startNodeDrag(loc);
                break;
            }
            case 1: {
                if (!this.isAllowDoubleClickActions()) {
                    return;
                }
                if (source != this) break;
                this.addNode(loc);
                break;
            }
            case 2: {
                DisplayNode nearestNode;
                if (source instanceof IDisplayEdge) {
                    return;
                }
                if (source instanceof DisplayNode) {
                    Point o = ((Component)source).getLocation();
                    loc.translate(o.x, o.y);
                }
                if ((nearestNode = this.findNearestNode(loc)) == null) break;
                this.startEdge(nearestNode, loc);
            }
        }
    }

    private void launchPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new LayoutMenu(this));
        popup.show(this, e.getX(), e.getY());
    }

    private void handleMouseReleased(MouseEvent e) {
        Object source = e.getSource();
        switch (this.workbenchMode) {
            case 0: {
                if (source == this) {
                    this.finishRubberband();
                    break;
                }
                if (!(source instanceof DisplayNode)) break;
                List<DisplayNode> dragNodes = this.dragNodes;
                if (dragNodes != null && dragNodes.isEmpty()) {
                    this.snapSingleNodeFromNegative(source);
                    this.snapNodeToGrid((DisplayNode)source);
                    this.scrollRectToVisible(((DisplayNode)source).getBounds());
                    break;
                }
                if (dragNodes == null) break;
                this.snapDragGroupFromNegative();
                Rectangle rect = dragNodes.get(0).getBounds();
                for (int i = 1; i < dragNodes.size(); ++i) {
                    rect = rect.union(dragNodes.get(i).getBounds());
                }
                break;
            }
            case 2: {
                this.finishEdge();
            }
        }
    }

    private void handleMouseDragged(MouseEvent e) {
        this.setMouseDragging();
        Object source = e.getSource();
        Point newPoint = e.getPoint();
        switch (this.workbenchMode) {
            case 0: {
                this.dragNodes(source, newPoint, e.isShiftDown());
                break;
            }
            case 1: {
                if (!(source instanceof DisplayNode) || !this.getSelectedComponents().isEmpty()) break;
                this.dragNodes(source, newPoint, e.isShiftDown());
                break;
            }
            case 2: {
                this.dragNewEdge(source, newPoint);
            }
        }
    }

    private void handleMouseEntered(MouseEvent e) {
        Map<String, Object> attributes;
        DisplayNode displayNode;
        Node node;
        List<EdgeTypeProbability> edgeProb;
        DisplayEdge displayEdge;
        Edge edge;
        Object source = e.getSource();
        if (source instanceof DisplayEdge && this.graph.containsEdge(edge = (displayEdge = (DisplayEdge)source).getModelEdge()) && (edgeProb = edge.getEdgeTypeProbabilities()) != null) {
            Object endpoint2;
            String endpoint1;
            switch (endpoint1 = edge.getEndpoint1().toString()) {
                case "Tail": {
                    endpoint1 = "-";
                    break;
                }
                case "Arrow": {
                    endpoint1 = "<";
                    break;
                }
                case "Circle": {
                    endpoint1 = "o";
                    break;
                }
                case "Star": {
                    endpoint1 = "*";
                    break;
                }
                case "Null": {
                    endpoint1 = "Null";
                }
            }
            switch (endpoint2 = edge.getEndpoint2().toString()) {
                case "Tail": {
                    endpoint2 = "-";
                    break;
                }
                case "Arrow": {
                    endpoint2 = ">";
                    break;
                }
                case "Circle": {
                    endpoint2 = "o";
                    break;
                }
                case "Star": {
                    endpoint2 = "*";
                    break;
                }
                case "Null": {
                    endpoint2 = "Null";
                }
            }
            StringBuilder properties = new StringBuilder();
            if (edge.getProperties() != null && edge.getProperties().size() > 0) {
                for (Edge.Property property : edge.getProperties()) {
                    properties.append(" ").append(property.toString());
                }
            }
            StringBuilder text = new StringBuilder("<html>" + edge.getNode1().getName() + " " + endpoint1 + "-" + (String)endpoint2 + " " + edge.getNode2().getName() + properties + "<br>");
            String n1 = edge.getNode1().getName();
            String n2 = edge.getNode2().getName();
            ArrayList<String> nodes = new ArrayList<String>();
            nodes.add(n1);
            nodes.add(n2);
            Collections.sort(nodes);
            for (EdgeTypeProbability edgeTypeProb : edgeProb) {
                String _type = "" + (Object)((Object)edgeTypeProb.getEdgeType());
                switch (edgeTypeProb.getEdgeType()) {
                    case nil: {
                        _type = "no edge";
                        break;
                    }
                    case ta: {
                        _type = "--?";
                        _type = (String)nodes.get(0) + " " + _type + " " + (String)nodes.get(1);
                        break;
                    }
                    case at: {
                        _type = "<--";
                        _type = (String)nodes.get(0) + " " + _type + " " + (String)nodes.get(1);
                        break;
                    }
                    case ca: {
                        _type = "o->";
                        _type = (String)nodes.get(0) + " " + _type + " " + (String)nodes.get(1);
                        break;
                    }
                    case ac: {
                        _type = "<-o";
                        _type = (String)nodes.get(0) + " " + _type + " " + (String)nodes.get(1);
                        break;
                    }
                    case cc: {
                        _type = "o-o";
                        _type = (String)nodes.get(0) + " " + _type + " " + (String)nodes.get(1);
                        break;
                    }
                    case aa: {
                        _type = "<->";
                        _type = (String)nodes.get(0) + " " + _type + " " + (String)nodes.get(1);
                        break;
                    }
                    case tt: {
                        _type = "---";
                        _type = (String)nodes.get(0) + " " + _type + " " + (String)nodes.get(1);
                        break;
                    }
                }
                if (!(edgeTypeProb.getProbability() > 0.0)) continue;
                properties = new StringBuilder();
                if (edgeTypeProb.getProperties() != null && edgeTypeProb.getProperties().size() > 0) {
                    for (Edge.Property property : edgeTypeProb.getProperties()) {
                        properties.append(" ").append(property.toString());
                    }
                }
                text.append("[").append(_type).append((CharSequence)properties).append("]:").append(String.format("%.4f", edgeTypeProb.getProbability()));
                text.append("<br>");
            }
            this.setEdgeToolTip(edge, text.toString());
        }
        if (source instanceof DisplayNode && this.graph.containsNode(node = (displayNode = (DisplayNode)source).getModelNode()) && !(attributes = node.getAllAttributes()).isEmpty()) {
            StringBuilder attribute = new StringBuilder();
            for (String key : attributes.keySet()) {
                Object value = attributes.get(key);
                attribute.append(key).append(": ").append(value).append("<br>");
            }
            String text = "<html>Node: " + node.getName() + "<br>" + attribute;
            this.setNodeToolTip(node, text);
        }
    }

    private void snapSingleNodeFromNegative(Object source) {
        DisplayNode node = (DisplayNode)source;
        int x = node.getLocation().x;
        int y = node.getLocation().y;
        x = FastMath.max(x, 0);
        y = FastMath.max(y, 0);
        node.setLocation(x, y);
    }

    private void snapDragGroupFromNegative() {
        int y;
        int x;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        List<DisplayNode> dragNodes = this.dragNodes;
        if (dragNodes == null) {
            return;
        }
        for (DisplayNode _node : dragNodes) {
            x = _node.getLocation().x;
            y = _node.getLocation().y;
            minX = FastMath.min(minX, x);
            minY = FastMath.min(minY, y);
        }
        minX = FastMath.min(minX, 0);
        minY = FastMath.min(minY, 0);
        for (DisplayNode _node : dragNodes) {
            x = _node.getLocation().x;
            y = _node.getLocation().y;
            _node.setLocation(x - minX, y - minY);
        }
    }

    private void dragNewEdge(Object source, Point newPoint) {
        if (source instanceof DisplayNode) {
            Point point = ((Component)source).getLocation();
            newPoint.translate(point.x, point.y);
        }
        if (this.getTrackedEdge() != null) {
            this.getTrackedEdge().updateTrackPoint(newPoint);
        }
    }

    private void dragNodes(Object source, Point newPoint, boolean edgesOnly) {
        if (!this.isAllowNodeDragging()) {
            return;
        }
        if (source instanceof DisplayNode) {
            List<DisplayNode> dragNodes = this.dragNodes;
            if (dragNodes == null) {
                return;
            }
            if (!dragNodes.contains(source)) {
                this.moveSingleNode(source, newPoint);
            } else {
                this.moveSelectedNodes(source, newPoint);
            }
        } else if (this.rubberband != null) {
            this.rubberband.updateTrackPoint(newPoint);
            this.selectAllInRubberband(this.rubberband, edgesOnly);
        }
    }

    private void moveSingleNode(Object source, Point newPoint) {
        DisplayNode node = (DisplayNode)source;
        int deltaX = newPoint.x - this.clickPoint.x;
        int deltaY = newPoint.y - this.clickPoint.y;
        int newX = node.getLocation().x + deltaX;
        int newY = node.getLocation().y + deltaY;
        node.setLocation(newX, newY);
    }

    private void moveSelectedNodes(Object source, Point newPoint) {
        if (!this.dragNodes.contains(source)) {
            return;
        }
        int deltaX = newPoint.x - this.clickPoint.x;
        int deltaY = newPoint.y - this.clickPoint.y;
        for (DisplayNode _node : this.dragNodes) {
            int newX = _node.getLocation().x + deltaX;
            int newY = _node.getLocation().y + deltaY;
            _node.setLocation(newX, newY);
        }
    }

    private void directEdge(IDisplayEdge graphEdge, int endpoint) {
        Edge newEdge;
        Edge edge = graphEdge.getModelEdge();
        if (edge == null) {
            throw new IllegalStateException("Graph edge without model edge: " + graphEdge);
        }
        if (endpoint == 1) {
            newEdge = Edges.directedEdge(edge.getNode2(), edge.getNode1());
        } else if (endpoint == 2) {
            newEdge = Edges.directedEdge(edge.getNode1(), edge.getNode2());
        } else {
            throw new IllegalArgumentException("Endpoint number should be 1 or 2.");
        }
        this.getGraph().removeEdge(edge);
        try {
            boolean added = this.getGraph().addEdge(newEdge);
            if (!added) {
                this.getGraph().addEdge(edge);
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Reorienting that edge would violate graph constraints.");
            }
        }
        catch (IllegalArgumentException e) {
            this.getGraph().addEdge(edge);
            if (this.doPagColoring) {
                GraphUtils.addPagColoring(new EdgeListGraph(this.graph));
            }
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Reorienting that edge would violate graph constraints.");
        }
        this.revalidate();
        this.repaint();
    }

    private void toggleEndpoint(IDisplayEdge graphEdge, int endpointNumber) {
        Edge newEdge;
        Endpoint endpoint;
        Edge edge = graphEdge.getModelEdge();
        if (endpointNumber == 1) {
            endpoint = edge.getEndpoint1();
            Endpoint nextEndpoint = endpoint == Endpoint.TAIL ? Endpoint.ARROW : (endpoint == Endpoint.ARROW ? Endpoint.CIRCLE : Endpoint.TAIL);
            newEdge = new Edge(edge.getNode1(), edge.getNode2(), nextEndpoint, edge.getEndpoint2());
        } else if (endpointNumber == 2) {
            endpoint = edge.getEndpoint2();
            Endpoint nextEndpoint = endpoint == Endpoint.TAIL ? Endpoint.ARROW : (endpoint == Endpoint.ARROW ? Endpoint.CIRCLE : Endpoint.TAIL);
            newEdge = new Edge(edge.getNode1(), edge.getNode2(), edge.getEndpoint1(), nextEndpoint);
        } else {
            throw new IllegalArgumentException("Endpoint number should be 1 or 2.");
        }
        this.getGraph().removeEdge(edge);
        try {
            boolean added = this.getGraph().addEdge(newEdge);
            if (!added) {
                this.getGraph().addEdge(edge);
                if (this.doPagColoring) {
                    GraphUtils.addPagColoring(new EdgeListGraph(this.graph));
                }
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.getGraph().addEdge(edge);
            return;
        }
        if (this.doPagColoring) {
            GraphUtils.addPagColoring(new EdgeListGraph(this.graph));
        }
        this.revalidate();
        this.repaint();
    }

    private void setMouseDragging() {
        boolean mouseDragging = true;
    }

    private boolean isAddMeasuredVarsAllowed() {
        return true;
    }

    boolean isEditExistingMeasuredVarsAllowed() {
        return true;
    }

    private boolean isDeleteVariablesAllowed() {
        return true;
    }

    public boolean isEnableEditing() {
        return this.enableEditing;
    }

    public void enableEditing(boolean enableEditing) {
        this.enableEditing = enableEditing;
        this.setEnabled(enableEditing);
    }

    public void setDoPagColoring(boolean doPagColoring) {
        this.doPagColoring = doPagColoring;
        if (doPagColoring) {
            GraphUtils.addPagColoring(this.graph);
        } else {
            for (Edge edge : this.graph.getEdges()) {
                edge.getProperties().clear();
            }
        }
        this.setGraph(this.graph);
        this.revalidate();
        this.repaint();
    }

    public boolean isDoPagColoring() {
        return this.doPagColoring;
    }

    private void doDoubleClickAction(DisplayNode node) {
        this.deselectAll();
        node.doDoubleClickAction(this.getGraph());
    }

    private Map<Object, Object> getDisplayToLabels() {
        return this.displayToLabels;
    }

    private void reconstiteMaps() {
        this.modelEdgesToDisplay = new HashMap<Edge, Object>(this.getModelEdgesToDisplay());
        this.modelNodesToDisplay = new HashMap<Node, Object>(this.getModelNodesToDisplay());
        this.displayToModel = new HashMap<Object, Object>(this.displayToModel);
        this.displayToLabels = new HashMap<Object, Object>(this.displayToLabels);
    }

    private IDisplayEdge getTrackedEdge() {
        return this.trackedEdge;
    }

    private boolean isNodeEdgeErrorsReported() {
        return this.nodeEdgeErrorsReported;
    }

    protected void setNodeEdgeErrorsReported() {
        this.nodeEdgeErrorsReported = true;
    }

    private boolean isRightClickPopupAllowed() {
        return this.rightClickPopupAllowed;
    }

    protected void setRightClickPopupAllowed(boolean rightClickPopupAllowed) {
        this.rightClickPopupAllowed = rightClickPopupAllowed;
    }

    private static final class ComponentHandler
    extends ComponentAdapter {
        private final AbstractWorkbench workbench;

        public ComponentHandler(AbstractWorkbench workbench) {
            this.workbench = workbench;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Component source = (Component)e.getSource();
            Rectangle bounds = source.getBounds();
            if (source instanceof DisplayNode) {
                Node modelNode = (Node)this.workbench.getDisplayToModel().get(source);
                if (modelNode == null) {
                    return;
                }
                int centerX = bounds.x + bounds.width / 2;
                int centerY = bounds.y + bounds.height / 2;
                modelNode.setCenterX(centerX);
                modelNode.setCenterY(centerY);
                this.workbench.adjustPreferredSize();
            }
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private final AbstractWorkbench workbench;

        public MouseHandler(AbstractWorkbench workbench) {
            this.workbench = workbench;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (AbstractWorkbench.this.isEnableEditing()) {
                this.workbench.handleMouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.workbench.handleMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (AbstractWorkbench.this.isEnableEditing()) {
                this.workbench.handleMouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (AbstractWorkbench.this.isEnableEditing()) {
                this.workbench.handleMouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static final class MouseMotionHandler
    extends MouseMotionAdapter {
        private final AbstractWorkbench workbench;

        public MouseMotionHandler(AbstractWorkbench workbench) {
            this.workbench = workbench;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.workbench.currentMouseLocation = e.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.workbench.handleMouseDragged(e);
        }
    }

    private final class PropertyChangeHandler
    implements PropertyChangeListener {
        private final AbstractWorkbench workbench;

        public PropertyChangeHandler(AbstractWorkbench workbench) {
            this.workbench = workbench;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propName = e.getPropertyName();
            Object oldValue = e.getOldValue();
            Object newValue = e.getNewValue();
            if ("nodeAdded".equals(propName)) {
                this.workbench.addNode((Node)newValue);
            } else if ("nodeRemoved".equals(propName)) {
                this.workbench.removeNode((Node)oldValue);
            } else if ("edgeAdded".equals(propName)) {
                this.workbench.addEdge((Edge)newValue);
            } else if ("edgeRemoved".equals(propName)) {
                this.workbench.removeEdge((Edge)oldValue);
            } else if ("edgeLaunch".equals(propName)) {
                System.out.println("Attempt to launch edge.");
            } else if ("deleteNode".equals(propName)) {
                Object node = e.getSource();
                if (node instanceof DisplayNode) {
                    node = this.workbench.displayToModel.get(node);
                }
                if (node instanceof GraphNode) {
                    this.workbench.deselectAll();
                    this.workbench.selectNode((GraphNode)node);
                    this.workbench.deleteSelectedObjects();
                }
            } else if ("cloneMe".equals(propName)) {
                AbstractWorkbench.this.firePropertyChange("cloneMe", e.getOldValue(), e.getNewValue());
            }
        }
    }

    private static final class GraphEdgeLabel
    extends JComponent
    implements PropertyChangeListener {
        private final IDisplayEdge edge;
        private final JComponent label;
        private double normalDistance;

        public GraphEdgeLabel(IDisplayEdge edge, JComponent label) {
            this.label = label;
            this.edge = edge;
            this.setLayout(new BorderLayout());
            this.add((Component)label, "Center");
            this.updateLocation(edge.getPointPair());
            ((Component)((Object)edge)).addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == this.edge && e.getPropertyName().equals("newPointPair")) {
                this.updateLocation((PointPair)e.getNewValue());
            }
        }

        void updateLocation(PointPair pp) {
            if (pp != null) {
                this.moveCenterOutAlongNormal(pp);
            }
        }

        private void moveCenterOutAlongNormal(PointPair pp) {
            double dx = pp.getFrom().x - pp.getTo().x;
            double dy = pp.getFrom().y - pp.getTo().y;
            double dist = AbstractWorkbench.distance(pp.getFrom(), pp.getTo());
            double normalx = -dy / dist;
            double normaly = dx / dist;
            Point midPt = new Point((pp.getFrom().x + pp.getTo().x) / 2, (pp.getFrom().y + pp.getTo().y) / 2);
            Point edgeLoc = ((Component)((Object)this.edge)).getLocation();
            int setx = edgeLoc.x + midPt.x;
            setx += (int)(this.getNormalDistance() * normalx) / 2;
            int sety = edgeLoc.y + midPt.y;
            sety += (int)(this.getNormalDistance() * normaly) / 2;
            this.setLocation(setx -= this.getLabel().getWidth() / 2, sety -= this.getLabel().getHeight() / 2);
        }

        public double getNormalDistance() {
            return this.normalDistance;
        }

        public JComponent getLabel() {
            return this.label;
        }
    }

    private static final class GraphNodeLabel
    extends JComponent {
        private final JComponent label;
        private final int xOffset;
        private final int yOffset;

        public GraphNodeLabel(DisplayNode node, JComponent label, int xOffset, int yOffset) {
            this.label = label;
            Rectangle rectangle = node.getBounds();
            this.xOffset = (int)rectangle.getWidth() / 2 + xOffset;
            this.yOffset = (int)rectangle.getHeight() / 2 + yOffset;
            this.setLayout(new BorderLayout());
            this.add((Component)label, "Center");
            this.updateLocation(node);
            node.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.updateLocation(e.getComponent());
                }
            });
        }

        void updateLocation(Component component) {
            int x = component.getX() + component.getWidth() / 2 + this.xOffset;
            int y = component.getY() + component.getHeight() / 2 + this.yOffset;
            this.setLocation(x, y);
        }

        public JComponent getLabel() {
            return this.label;
        }
    }
}

