/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.util.LayoutEditable;
import edu.cmu.tetradapp.workbench.DisplayNode;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class CausalOrder {
    private final Graph graph;
    private final LayoutEditable layoutEditable;

    public CausalOrder(LayoutEditable layoutEditable) {
        this.graph = layoutEditable.getGraph();
        this.layoutEditable = layoutEditable;
    }

    public void doLayout() {
        List<List<Node>> tiers = this.getTiers();
        int y = 0;
        for (List<Node> tier : tiers) {
            y += 60;
            if (tier.isEmpty()) continue;
            Node node = tier.get(0);
            DisplayNode displayNode = (DisplayNode)this.layoutEditable.getModelNodesToDisplay().get(node);
            Rectangle r = displayNode.getBounds();
            int x = r.width / 2 + 10;
            node.setCenterX(x);
            node.setCenterY(y);
            int lastHalf = r.width / 2;
            for (int i = 1; i < tier.size(); ++i) {
                node = tier.get(i);
                displayNode = (DisplayNode)this.layoutEditable.getModelNodesToDisplay().get(node);
                r = displayNode.getBounds();
                int thisHalf = r.width / 2;
                node.setCenterX(x += lastHalf + thisHalf + 5);
                node.setCenterY(y);
                lastHalf = thisHalf;
            }
        }
    }

    private List<List<Node>> getTiers() {
        HashSet found = new HashSet();
        LinkedList<List<Node>> tiers = new LinkedList<List<Node>>();
        HashSet<Node> notFound = new HashSet<Node>(this.graph.getNodes());
        while (!notFound.isEmpty()) {
            LinkedList<Node> thisTier = new LinkedList<Node>();
            for (Node node : notFound) {
                if (!found.containsAll(this.graph.getParents(node))) continue;
                thisTier.add(node);
            }
            if (thisTier.isEmpty()) {
                tiers.add(new ArrayList<Node>(notFound));
                break;
            }
            thisTier.forEach(notFound::remove);
            found.addAll(thisTier);
            tiers.add(thisTier);
        }
        return tiers;
    }

    private void placeNodes(Node node, Map<Node, Integer> tiers, Graph graph) {
        if (tiers.containsKey(node)) {
            return;
        }
        Set<Node> keySet = tiers.keySet();
        List<Node> parents = graph.getParents(node);
        parents.retainAll(keySet);
        List<Node> children = graph.getChildren(node);
        children.retainAll(keySet);
        if (parents.isEmpty() && children.isEmpty()) {
            tiers.put(node, 0);
        } else {
            if (parents.isEmpty()) {
                int cMin = this.getCMin(children, tiers);
                tiers.put(node, cMin - 1);
                this.placeChildren(node, tiers, graph);
                return;
            }
            int pMax = this.getPMax(parents, tiers);
            int cMin = this.getCMin(children, tiers);
            tiers.put(node, pMax + 1);
            if (!children.isEmpty() && cMin < pMax + 2) {
                int diff = pMax + 2 - cMin;
                List<Node> descendants = graph.paths().getDescendants(Collections.singletonList(node));
                descendants.retainAll(keySet);
                descendants.remove(node);
                for (Node descendant : descendants) {
                    Integer index = tiers.get(descendant);
                    tiers.put(descendant, index + diff);
                }
            }
        }
        this.placeChildren(node, tiers, graph);
    }

    private void placeChildren(Node node, Map<Node, Integer> tiers, Graph graph) {
        List<Node> adj = graph.getAdjacentNodes(node);
        for (Node _node : adj) {
            this.placeNodes(_node, tiers, graph);
        }
    }

    private int getPMax(List<Node> parents, Map<Node, Integer> tiers) {
        int pMax = Integer.MIN_VALUE;
        for (Node parent : parents) {
            Integer index = tiers.get(parent);
            if (index <= pMax) continue;
            pMax = index;
        }
        return pMax;
    }

    private int getCMin(List<Node> children, Map<Node, Integer> tiers) {
        int cMin = Integer.MAX_VALUE;
        for (Node child : children) {
            Integer index = tiers.get(child);
            if (index >= cMin) continue;
            cMin = index;
        }
        return cMin;
    }
}

