/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.data.AbstractVariable;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.NodeVariableType;
import edu.cmu.tetrad.util.TetradSerializableExcluded;
import edu.cmu.tetradapp.workbench.DisplayComp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class DisplayNode
extends JComponent
implements Node,
TetradSerializableExcluded {
    private Node modelNode;
    private boolean selected;
    private NodeVariableType nodeVariableType = NodeVariableType.DOMAIN;
    private DisplayComp displayComp;
    private final int uniqueId = AbstractVariable.LAST_ID++;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    protected DisplayNode() {
        this.setName("");
    }

    protected final void setModelNode(Node modelNode) {
        if (modelNode == null) {
            throw new NullPointerException();
        }
        this.modelNode = modelNode;
        this.setName(modelNode.getName());
        modelNode.addPropertyChangeListener(evt -> {
            if ("name".equals(evt.getPropertyName())) {
                this.setName((String)evt.getNewValue());
            }
        });
    }

    public final Node getModelNode() {
        return this.modelNode;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        super.setName(name);
        if (this.displayComp != null) {
            this.displayComp.setName(name);
        }
        this.repaint();
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.firePropertyChange("selected", oldSelected, selected);
        if (this.displayComp != null) {
            this.displayComp.setSelected(selected);
        }
        this.repaint();
    }

    public final boolean isSelected() {
        return this.selected;
    }

    @Override
    public final void setLocation(int x, int y) {
        super.setLocation(x, y);
        if (this.getModelNode() != null) {
            this.getModelNode().setCenter(x + this.getWidth() / 2, y + this.getHeight() / 2);
        }
    }

    public final Point getCenterPoint() {
        Rectangle bounds = this.getBounds();
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        return new Point(centerX, centerY);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.getDisplayComp() != null) {
            return this.getDisplayComp().contains(x, y);
        }
        return super.contains(x, y);
    }

    public void doDoubleClickAction() {
    }

    public void doDoubleClickAction(Graph graph) {
    }

    protected DisplayComp getDisplayComp() {
        return this.displayComp;
    }

    protected void setDisplayComp(DisplayComp displayComp) {
        this.displayComp = displayComp;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)((JComponent)((Object)displayComp)), "Center");
    }

    @Override
    public NodeType getNodeType() {
        return null;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
    }

    @Override
    public int getCenterX() {
        return 0;
    }

    @Override
    public void setCenterX(int centerX) {
    }

    @Override
    public int getCenterY() {
        return 0;
    }

    @Override
    public void setCenterY(int centerY) {
    }

    @Override
    public void setCenter(int centerX, int centerY) {
    }

    @Override
    public Node like(String name) {
        DisplayNode node = new DisplayNode();
        node.setName(name);
        node.setNodeType(this.getNodeType());
        return node;
    }

    @Override
    public int compareTo(Node node) {
        String name = this.getName();
        String[] tokens1 = name.split(":");
        String _name = node.getName();
        String[] tokens2 = _name.split(":");
        if (tokens1.length == 1) {
            tokens1 = new String[]{tokens1[0], "0"};
        }
        if (tokens2.length == 1) {
            tokens2 = new String[]{tokens2[0], "0"};
        }
        int i1 = tokens1[1].compareTo(tokens2[1]);
        int i2 = tokens1[0].compareTo(tokens2[0]);
        if (i1 == 0) {
            return i2;
        }
        return i1;
    }

    @Override
    public NodeVariableType getNodeVariableType() {
        return this.nodeVariableType;
    }

    @Override
    public void setNodeVariableType(NodeVariableType nodeVariableType) {
        this.nodeVariableType = nodeVariableType;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

