/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.workbench;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetradapp.workbench.DisplayNode;
import edu.cmu.tetradapp.workbench.LatentDisplayComp;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GraphNodeLocked
extends DisplayNode {
    public GraphNodeLocked(Node modelNode) {
        this.setModelNode(modelNode);
        if (modelNode.getNodeType() != NodeType.LATENT) {
            throw new IllegalArgumentException("GraphNodeLatent requires a GraphNode of type NodeType.LATENT.");
        }
        this.setDisplayComp(new LatentDisplayComp(modelNode.getName()));
    }

    @Override
    public void doDoubleClickAction(Graph graph) {
        List<Node> nodes = graph.getNodes();
        JCheckBox latentCheckBox = new JCheckBox("Latent", true);
        String newName = this.chooseNewVariableName(latentCheckBox, nodes);
        boolean changed = false;
        if (this.getModelNode() != null && !newName.equals(this.getModelNode().getName())) {
            this.getModelNode().setName(newName);
            this.firePropertyChange("resetGraph", null, null);
            changed = true;
        }
        if (!latentCheckBox.isSelected()) {
            this.getModelNode().setNodeType(NodeType.MEASURED);
            this.firePropertyChange("resetGraph", null, null);
            changed = true;
        }
        if (changed) {
            this.firePropertyChange("editingValueChanged", null, null);
        }
    }

    private String chooseNewVariableName(JCheckBox latentCheckBox, List<Node> nodes) {
        String newName;
        block0: while (true) {
            JTextField nameField = new JTextField(8);
            nameField.addFocusListener(new FocusAdapter(){
                boolean alreadyLostFocus;

                @Override
                public void focusLost(FocusEvent e) {
                    if (this.alreadyLostFocus) {
                        return;
                    }
                    JTextField field = (JTextField)e.getSource();
                    field.grabFocus();
                    this.alreadyLostFocus = true;
                }
            });
            nameField.setText(this.getName());
            nameField.setCaretPosition(0);
            nameField.moveCaretPosition(this.getName().length());
            JPanel message = new JPanel();
            message.add(new JLabel("Name:"));
            message.add(nameField);
            message.add(latentCheckBox);
            JOptionPane pane = new JOptionPane(message, -1, 2);
            JDialog dialog = pane.createDialog(this, "Node Properties");
            dialog.pack();
            dialog.setVisible(true);
            newName = nameField.getText();
            if (!NamingProtocol.isLegalName(newName)) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), NamingProtocol.getProtocolDescription());
                continue;
            }
            if (nodes == null) break;
            for (Node node : nodes) {
                if (!newName.equals(node.toString()) || newName.equals(this.getModelNode().getName())) continue;
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "The name '" + newName + "' is already being used.\nPlease choose another name.");
                continue block0;
            }
            break;
        }
        return newName;
    }

    @Override
    public void doDoubleClickAction() {
        this.doDoubleClickAction(new EdgeListGraph());
    }
}

